/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.guava.common.cache;

import java.util.concurrent.Executor;
import org.forgerock.guava.common.annotations.Beta;
import org.forgerock.guava.common.base.Preconditions;
import org.forgerock.guava.common.cache.RemovalListener;
import org.forgerock.guava.common.cache.RemovalNotification;

@Beta
public final class RemovalListeners {
    private RemovalListeners() {
    }

    public static <K, V> RemovalListener<K, V> asynchronous(final RemovalListener<K, V> listener, final Executor executor) {
        Preconditions.checkNotNull(listener);
        Preconditions.checkNotNull(executor);
        return new RemovalListener<K, V>(){

            @Override
            public void onRemoval(final RemovalNotification<K, V> notification) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        listener.onRemoval(notification);
                    }
                });
            }
        };
    }
}

