/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.forgerock.api.models.Resource;
import org.forgerock.api.util.PathUtil;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public final class SubResources {
    private final Map<String, Resource> subResources;

    private SubResources(Builder builder) {
        this.subResources = builder.subResources;
    }

    @JsonValue
    public Map<String, Resource> getSubResources() {
        return this.subResources;
    }

    @JsonIgnore
    public Resource get(String name) {
        return this.subResources.get(name);
    }

    @JsonIgnore
    public Set<String> getNames() {
        return this.subResources.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubResources that = (SubResources)o;
        return Objects.equals(this.subResources, that.subResources);
    }

    public int hashCode() {
        return Objects.hash(this.subResources);
    }

    public static Builder subresources() {
        return new Builder();
    }

    public static final class Builder {
        private final Map<String, Resource> subResources = new HashMap<String, Resource>();

        private Builder() {
        }

        @JsonAnySetter
        public Builder put(String path, Resource resource) {
            if (path == null || ValidationUtil.containsWhitespace(path)) {
                throw new IllegalArgumentException("path required and may not contain whitespace");
            }
            if (!path.isEmpty()) {
                path = PathUtil.buildPath(path, new String[0]);
            }
            if (this.subResources.containsKey(path)) {
                throw new IllegalStateException("path not unique");
            }
            this.subResources.put(path, Reject.checkNotNull(resource));
            return this;
        }

        public SubResources build() {
            return new SubResources(this);
        }
    }
}

