/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.enums.PatchOperation;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Operation;
import org.forgerock.api.models.Resource;
import org.forgerock.api.util.ValidationUtil;

@JsonDeserialize(builder=Builder.class)
public final class Patch
extends Operation {
    private final PatchOperation[] operations;

    private Patch(Builder builder) {
        super(builder);
        this.operations = builder.operations;
        if (ValidationUtil.isEmpty((Object[])this.operations)) {
            throw new ApiValidationException("operations required");
        }
    }

    public PatchOperation[] getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Patch patch = (Patch)o;
        return Arrays.equals((Object[])this.operations, (Object[])patch.operations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.operations});
    }

    public static final Builder patch() {
        return new Builder();
    }

    @Override
    protected void allocateToResource(Resource.Builder resourceBuilder) {
        resourceBuilder.patch(this);
    }

    public static Patch fromAnnotation(org.forgerock.api.annotations.Patch patch, ApiDescription descriptor, Class<?> relativeType) {
        return ((Builder)Patch.patch().detailsFromAnnotation(patch.operationDescription(), descriptor, relativeType)).operations(patch.operations()).build();
    }

    public static final class Builder
    extends Operation.Builder<Builder> {
        private PatchOperation[] operations;

        private Builder() {
        }

        @JsonProperty(value="operations")
        public Builder operations(PatchOperation ... operations) {
            this.operations = operations;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Patch build() {
            return new Patch(this);
        }
    }
}

