/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import java.io.IOException;
import org.forgerock.api.models.Paths;
import org.forgerock.util.Reject;

public final class PathsModule
extends SimpleModule {
    public PathsModule() {
        this.setSerializerModifier(new PathsModifier());
    }

    private static final class PathsModifier
    extends BeanSerializerModifier {
        private PathsModifier() {
        }

        @Override
        public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
            if (beanDesc.getBeanClass() == Paths.class) {
                return new PathsSerializer(serializer);
            }
            return serializer;
        }
    }

    private static final class PathsSerializer
    extends JsonSerializer<Paths> {
        private final JsonSerializer<Object> defaultSerializer;

        private PathsSerializer(JsonSerializer<Object> defaultSerializer) {
            this.defaultSerializer = Reject.checkNotNull(defaultSerializer);
        }

        @Override
        public void serialize(Paths value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            this.defaultSerializer.serialize(value, gen, serializers);
        }

        @Override
        public boolean isEmpty(SerializerProvider provider, Paths value) {
            return value.getNames().isEmpty();
        }
    }
}

