/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import java.io.IOException;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResult;
import org.forgerock.util.Reject;

public final class GetConnectionIdExtendedResult
extends AbstractExtendedResult<GetConnectionIdExtendedResult> {
    private int connectionId = -1;

    public static GetConnectionIdExtendedResult newResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new GetConnectionIdExtendedResult(resultCode);
    }

    private GetConnectionIdExtendedResult(ResultCode resultCode) {
        super(resultCode);
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    @Override
    public String getOid() {
        return "1.3.6.1.4.1.26027.1.6.2";
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder(6);
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeInteger(this.connectionId);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    public GetConnectionIdExtendedResult setConnectionId(int connectionId) {
        this.connectionId = connectionId;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetConnectionIDExtendedResponse(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDn());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralUris());
        builder.append(", responseName=");
        builder.append(this.getOid());
        builder.append(", connectionId=");
        builder.append(this.connectionId);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }
}

