/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.LoggingCategoryNames;
import com.forgerock.opendj.util.StaticUtils;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.forgerock.util.Reject;

public final class JdkLogging {
    private static final String[] LOGGING_ROOTS = new String[]{"org.opends", "org.forgerock.opendj"};
    private static final Logger[] LOGGER_ROOTS = new Logger[LOGGING_ROOTS.length];

    public static void disableLogging() {
        LogManager.getLogManager().reset();
        Logger.getLogger("").setLevel(Level.OFF);
    }

    public static void enableConsoleLoggingForLdapTool(Handler handler) {
        JdkLogging.enableConsoleLoggingForOpenDJTool(Level.ALL, new JdkLoggingFormatter(), handler);
    }

    public static void enableConsoleLoggingForOpenDJTool(Level level) {
        JdkLogging.enableConsoleLoggingForOpenDJTool(level, new JdkLoggingFormatter(), new OpenDJHandler(System.out, System.err));
    }

    public static void enableLoggingForOpenDJTool(Level level, PrintStream stream) {
        JdkLogging.enableConsoleLoggingForOpenDJTool(level, new JdkLoggingFormatter(), new OpenDJHandler(stream, stream));
    }

    private static void enableConsoleLoggingForOpenDJTool(Level level, Formatter formatter, Handler handler) {
        Reject.ifNull(level, formatter, handler);
        LogManager.getLogManager().reset();
        handler.setFormatter(formatter);
        handler.setLevel(level);
        for (int i = 0; i < LOGGING_ROOTS.length; ++i) {
            Logger logger = Logger.getLogger(LOGGING_ROOTS[i]);
            logger.setLevel(level);
            logger.addHandler(handler);
            JdkLogging.LOGGER_ROOTS[i] = logger;
        }
    }

    public static String[] getOpendDJLoggingRoots() {
        return LOGGING_ROOTS;
    }

    private JdkLogging() {
    }

    private static final class OpenDJHandler
    extends Handler {
        private final PrintStream out;
        private final PrintStream err;

        private OpenDJHandler(PrintStream out, PrintStream err) {
            this.out = Reject.checkNotNull(out, "out PrintStream cannot be null for OpenDJHandler");
            this.err = Reject.checkNotNull(err, "err PrintStream cannot be null for OpenDJHandler");
        }

        @Override
        public void publish(LogRecord record) {
            try {
                byte[] message = this.getFormatter().format(record).getBytes();
                if (record.getLevel().intValue() >= Level.WARNING.intValue()) {
                    this.err.write(message);
                } else {
                    this.out.write(message);
                }
            }
            catch (Exception e) {
                this.reportError(null, e, 5);
            }
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
            this.out.flush();
            this.err.flush();
        }
    }

    public static final class JdkLoggingFormatter
    extends Formatter {
        private static final ThreadLocal<DateFormat> DATE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                return new SimpleDateFormat("[dd/MM/yyyy:HH:mm:ss Z]");
            }
        };

        @Override
        public String format(LogRecord record) {
            StringBuilder builder = new StringBuilder();
            builder.append(DATE_FORMAT.get().format(new Date(record.getMillis()))).append(" category=").append(LoggingCategoryNames.getCategoryName(record.getLoggerName())).append(" seq=").append(record.getSequenceNumber()).append(" severity=").append(record.getLevel()).append(" msg=").append(record.getMessage());
            if (record.getThrown() != null) {
                builder.append(" exception=").append(StaticUtils.stackTraceToSingleLineString(record.getThrown(), false));
            }
            builder.append(System.lineSeparator());
            return builder.toString();
        }
    }
}

