/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.Argument;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.ByteArrayOutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;

public final class DocGenerationHelper {
    private static Configuration configuration;

    private DocGenerationHelper() {
    }

    private static Configuration getConfiguration() {
        if (configuration == null) {
            configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            configuration.setClassForTemplateLoading(DocGenerationHelper.class, "/templates");
            configuration.setDefaultEncoding("UTF-8");
            configuration.setTemplateExceptionHandler(TemplateExceptionHandler.DEBUG_HANDLER);
        }
        return configuration;
    }

    public static void applyTemplate(StringBuilder builder, String template, Map<String, Object> map) {
        configuration = DocGenerationHelper.getConfiguration();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
             OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            Template configurationTemplate = configuration.getTemplate(template);
            configurationTemplate.process(map, (Writer)writer);
            builder.append(outputStream.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String applyTemplate(String template, Map<String, Object> map) {
        StringBuilder builder = new StringBuilder();
        DocGenerationHelper.applyTemplate(builder, template, map);
        return builder.toString();
    }

    public static String getOptionSynopsis(Argument argument) {
        StringBuilder builder = new StringBuilder();
        Character shortID = argument.getShortIdentifier();
        if (shortID != null) {
            builder.append("-").append(shortID.charValue());
        }
        String longID = argument.getLongIdentifier();
        if (shortID != null && longID != null) {
            builder.append(" | ");
        }
        if (longID != null) {
            builder.append("--").append(longID);
        }
        if (argument.needsValue()) {
            builder.append(" ").append(argument.getValuePlaceholder());
        }
        return builder.toString();
    }
}

