<#--
 # The contents of this file are subject to the terms of the Common Development and
 # Distribution License (the License). You may not use this file except in compliance with the
 # License.
 #
 # You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 # specific language governing permission and limitations under the License.
 #
 # When distributing Covered Software, include this CDDL Header Notice in each file and include
 # the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 # Header, with the fields enclosed by brackets [] replaced by your own identifying
 # information: "Portions Copyright [year] [name of copyright owner]".
 #
 # Copyright 2017 ForgeRock AS.
 #-->
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <meta name="date" content="${now?datetime}">
    <link rel="stylesheet" href="style.css">
    <title>${title}</title>
  </head>

  <body>
    <div id="container">
    <h2 class="title">${title}</h2>

    <div class="section">
      <#if abstract??><p><i>${abstract}</i></p></#if>
      <p>${synopsis}</p>
      <#if description??><p>${description}</p></#if>
    </div>

    <#if childObjects??>
    <div class="section">
      <h3 class="title">${childObjects.title}</h3>

      <p>${childObjects.header}</p>

      <ul>
      <#list childObjects.links?keys as key>
        <li><a href="${key}${extension}">${childObjects.links[key]}</a></li>
      </#list>
      </ul>

      <p>${childObjects.trailer}</p>
    </div>
    </#if>

    <#if parent??>
    <div class="section">
      <h3 class="title">${parent.title}</h3>

      <p>${parent.description}
        <a href="${parent.link.page}${extension}">${parent.link.name}</a>.</p>
    </div>
    </#if>

    <#if relations??>
    <div class="section">
      <h3 class="title">${relations.title}</h3>

      <#if relations.aggregation??>
        <#if relations.aggregation.from??>
          <p>${relations.aggregation.from.description}</p>
          <ul>
          <#list relations.aggregation.from.links?keys as key>
            <li><a href="${key}${extension}">${relations.aggregation.from.links[key]}</a></li>
          </#list>
          </ul>
        </#if>

        <#if relations.aggregation.to??>
          <p>${relations.aggregation.to.description}</p>
          <ul>
          <#list relations.aggregation.to.links?keys as key>
            <li><a href="${key}${extension}">${relations.aggregation.to.links[key]}</a></li>
          </#list>
          </ul>
        </#if>
      </#if>

      <#if relations.composition??>
        <#if relations.composition.from??>
          <p>${relations.composition.from.description}</p>
          <ul>
          <#list relations.composition.from.links?keys as key>
            <li><a href="${key}${extension}">${relations.composition.from.links[key]}</a></li>
          </#list>
          </ul>
        </#if>

        <#if relations.composition.to??>
          <p>${relations.composition.to.description}</p>
          <ul>
          <#list relations.composition.to.links?keys as key>
            <li><a href="${key}${extension}">${relations.composition.to.links[key]}</a></li>
          </#list>
          </ul>
        </#if>
      </#if>
    </div>
    </#if>

    <div class="section">
      <h3 class="title">${properties.title}</h3>
      <p>${properties.header}</p>

      <div class="properties-list">
        <p><b>${properties.basic.title}</b></p>
        <#if properties.basic.names??>
          <ul>
          <#list properties.basic.names as name>
            <li><a href="#${name}">${name}</a></li>
          </#list>
          </ul>
        <#else>
          <ul><li>None</li></ul>
        </#if>

        <p><b>${properties.advanced.title}</b></p>
        <#if properties.advanced.names??>
          <ul>
          <#list properties.advanced.names as name>
            <li><a href="#${name}">${name}</a></li>
          </#list>
          </ul>
        <#else>
          <ul><li>None</li></ul>
        </#if>
      </div>
    </div>

    <#if properties.basic.props??>
    <div class="list">
      <h4 class="title">${properties.basic.title}</h4>

      <#list properties.basic.props as prop>
        <p class="property-name"><a id="${prop.name}">${prop.name}</a></p>
        <table class="property-table">
        <col class="first-column">
        <col class="second-column">
        <#list prop.attributes?keys as key>
          <tr><td>${key}</td><td>${prop.attributes[key]}</td></tr>
        </#list>
        </table>
      </#list>
    </div>
    </#if>

    <#if properties.advanced.props??>
    <div class="list">
      <h4 class="title">${properties.advanced.title}</h4>

      <#list properties.advanced.props as prop>
        <p class="property-name"><a id="${prop.name}">${prop.name}</a></p>
        <table class="property-table">
        <col class="first-column">
        <col class="second-column">
        <#list prop.attributes?keys as key>
          <tr><td>${key}</td><td>${prop.attributes[key]}</td></tr>
        </#list>
        </table>
      </#list>
    </div>
    </#if>
    </div>
    <footer><p>Copyright 2011-${now?string["yyyy"]} ForgeRock AS.</p></footer>
  </body>
</html>
