/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.time.Duration;

public class PerItemEvictionStrategyCache<K, V> {
    private static final Function<Exception, Duration, Exception> ON_EXCEPTION_NO_TIMEOUT = e -> Duration.ZERO;
    private final ScheduledExecutorService executorService;
    private final ConcurrentMap<K, CacheEntry<V>> cache = new ConcurrentHashMap<K, CacheEntry<V>>();
    private final AsyncFunction<V, Duration, Exception> defaultTimeoutFunction;
    private Duration maxTimeout;

    public PerItemEvictionStrategyCache(ScheduledExecutorService executorService, Duration defaultTimeout) {
        this(executorService, (V value) -> Promises.newResultPromise(defaultTimeout));
    }

    public PerItemEvictionStrategyCache(ScheduledExecutorService executorService, AsyncFunction<V, Duration, Exception> defaultTimeoutFunction) {
        this.executorService = Reject.checkNotNull(executorService);
        this.defaultTimeoutFunction = Reject.checkNotNull(defaultTimeoutFunction);
    }

    public V getValue(K key, Callable<V> callable) throws InterruptedException, ExecutionException {
        return this.getValue(key, callable, this.defaultTimeoutFunction);
    }

    public V getValue(K key, Callable<V> callable, AsyncFunction<V, Duration, Exception> expire) throws InterruptedException, ExecutionException {
        try {
            return this.createIfAbsent(key, callable, expire).get();
        }
        catch (InterruptedException | RuntimeException | ExecutionException e) {
            this.evict(key);
            throw e;
        }
    }

    private Future<V> createIfAbsent(K key, Callable<V> callable, AsyncFunction<V, Duration, Exception> timeoutFunction) throws InterruptedException, ExecutionException {
        FutureTask<V> futureTask;
        CacheEntry<V> futureCacheEntry;
        CacheEntry<V> cacheEntry = (CacheEntry<V>)this.cache.get(key);
        if (cacheEntry == null && (cacheEntry = this.cache.putIfAbsent(key, futureCacheEntry = new CacheEntry<V>(futureTask = new FutureTask<V>(callable)))) == null) {
            cacheEntry = futureCacheEntry;
            futureTask.run();
            this.scheduleEviction(key, futureCacheEntry, timeoutFunction);
        }
        return cacheEntry.getFutureTask();
    }

    private void scheduleEviction(K key, CacheEntry<V> cacheEntry, AsyncFunction<V, Duration, Exception> timeoutFunction) throws ExecutionException, InterruptedException {
        Promises.newResultPromise(cacheEntry.getFutureTask().get()).thenAsync(timeoutFunction).thenCatch(ON_EXCEPTION_NO_TIMEOUT).thenCatchRuntimeException(ON_EXCEPTION_NO_TIMEOUT).thenOnResult(timeout -> {
            Runnable eviction = () -> {
                if (this.cache.remove(key, cacheEntry)) {
                    cacheEntry.cancelExpiration();
                }
            };
            if (timeout == null || timeout.isZero()) {
                eviction.run();
            } else {
                if (this.maxTimeout != null) {
                    Duration duration = timeout = timeout.compareTo(this.maxTimeout) < 0 ? timeout : this.maxTimeout;
                }
                if (!timeout.isUnlimited()) {
                    ScheduledFuture<?> scheduledFuture = this.executorService.schedule(eviction, timeout.getValue(), timeout.getUnit());
                    cacheEntry.setScheduledHandler(scheduledFuture);
                }
            }
        });
    }

    public void clear() {
        for (Object key : this.cache.keySet()) {
            this.evict(key);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    public void evict(K key) {
        CacheEntry entry = (CacheEntry)this.cache.remove(key);
        if (entry != null) {
            entry.cancelExpiration();
        }
    }

    public Duration getMaxTimeout() {
        return this.maxTimeout;
    }

    public void setMaxTimeout(Duration maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    private static class CacheEntry<V> {
        private final FutureTask<V> futureTask;
        private ScheduledFuture<?> scheduledHandler;

        CacheEntry(FutureTask<V> futureTask) {
            this.futureTask = futureTask;
        }

        void setScheduledHandler(ScheduledFuture<?> scheduledHandler) {
            this.scheduledHandler = scheduledHandler;
        }

        FutureTask<V> getFutureTask() {
            return this.futureTask;
        }

        void cancelExpiration() {
            if (this.scheduledHandler != null) {
                this.scheduledHandler.cancel(false);
            }
        }
    }
}

