/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import org.forgerock.http.Filter;
import org.forgerock.http.Handler;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Pair;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;

final class HttpBasicAuthenticationFilter
implements Filter {
    private final AuthenticationStrategy authenticationStrategy;
    private final Function<Headers, Pair<String, String>, NeverThrowsException> credentialsExtractor;

    HttpBasicAuthenticationFilter(AuthenticationStrategy authenticationStrategy, Function<Headers, Pair<String, String>, NeverThrowsException> credentialsExtractor) {
        this.authenticationStrategy = Reject.checkNotNull(authenticationStrategy, "authenticationStrategy cannot be null");
        this.credentialsExtractor = Reject.checkNotNull(credentialsExtractor, "credentialsExtractor cannot be null");
    }

    @Override
    public Promise<Response, NeverThrowsException> filter(Context context, final Request request, final Handler next) {
        Pair<String, String> credentials = this.credentialsExtractor.apply(request.getHeaders());
        if (credentials == null) {
            return Utils.asErrorResponse(LdapException.newLdapException(ResultCode.INVALID_CREDENTIALS));
        }
        return this.authenticationStrategy.authenticate(credentials.getFirst(), credentials.getSecond(), context).thenAsync(new AsyncFunction<SecurityContext, Response, NeverThrowsException>(){

            @Override
            public Promise<Response, NeverThrowsException> apply(SecurityContext securityContext) {
                return next.handle(securityContext, request);
            }
        }, new AsyncFunction<LdapException, Response, NeverThrowsException>(){

            @Override
            public Promise<? extends Response, ? extends NeverThrowsException> apply(LdapException exception) {
                return Utils.asErrorResponse(exception instanceof EntryNotFoundException ? LdapException.newLdapException(ResultCode.INVALID_CREDENTIALS) : exception);
            }
        });
    }
}

