/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.spi;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.ResultHandler;
import org.forgerock.util.promise.RuntimeExceptionHandler;

class LdapPromiseWrapper<R, P extends Promise<R, LdapException>>
implements LdapPromise<R> {
    private final P wrappedPromise;
    private final int requestId;

    LdapPromiseWrapper(P wrappedPromise, int requestId) {
        this.wrappedPromise = wrappedPromise;
        this.requestId = requestId;
    }

    @Override
    public int getRequestId() {
        return this.wrappedPromise instanceof LdapPromise ? ((LdapPromise)this.wrappedPromise).getRequestId() : this.requestId;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.wrappedPromise.cancel(mayInterruptIfRunning);
    }

    @Override
    public R get() throws ExecutionException, InterruptedException {
        return (R)this.wrappedPromise.get();
    }

    @Override
    public R get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException, InterruptedException {
        return (R)this.wrappedPromise.get(timeout, unit);
    }

    @Override
    public R getOrThrow() throws InterruptedException, LdapException {
        return (R)this.wrappedPromise.getOrThrow();
    }

    @Override
    public R getOrThrow(long timeout, TimeUnit unit) throws InterruptedException, LdapException, TimeoutException {
        return (R)this.wrappedPromise.getOrThrow(timeout, unit);
    }

    @Override
    public R getOrThrowUninterruptibly() throws LdapException {
        return (R)this.wrappedPromise.getOrThrowUninterruptibly();
    }

    @Override
    public R getOrThrowUninterruptibly(long timeout, TimeUnit unit) throws LdapException, TimeoutException {
        return (R)this.wrappedPromise.getOrThrowUninterruptibly(timeout, unit);
    }

    @Override
    public boolean isCancelled() {
        return this.wrappedPromise.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.wrappedPromise.isDone();
    }

    @Override
    public LdapPromise<R> thenOnException(ExceptionHandler<? super LdapException> onException) {
        this.wrappedPromise.thenOnException(onException);
        return this;
    }

    public LdapPromise<R> thenOnRuntimeException(RuntimeExceptionHandler onRuntimeException) {
        this.wrappedPromise.thenOnRuntimeException(onRuntimeException);
        return this;
    }

    @Override
    public LdapPromise<R> thenOnResult(ResultHandler<? super R> onResult) {
        this.wrappedPromise.thenOnResult(onResult);
        return this;
    }

    @Override
    public LdapPromise<R> thenOnResultOrException(Runnable onResultOrException) {
        this.wrappedPromise.thenOnResultOrException(onResultOrException);
        return this;
    }

    @Override
    public <VOUT> LdapPromise<VOUT> then(Function<? super R, VOUT, LdapException> onResult) {
        return LdapPromises.wrap(this.wrappedPromise.then(onResult), this.getRequestId());
    }

    @Override
    public <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> then(Function<? super R, VOUT, EOUT> onResult, Function<? super LdapException, VOUT, EOUT> onException) {
        return this.wrappedPromise.then(onResult, onException);
    }

    @Override
    public <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> then(Function<? super R, VOUT, EOUT> onResult, Function<? super LdapException, VOUT, EOUT> onException, Function<? super RuntimeException, VOUT, EOUT> onRuntimeException) {
        return this.wrappedPromise.then(onResult, onException, onRuntimeException);
    }

    @Override
    public LdapPromise<R> thenOnResultOrException(ResultHandler<? super R> onResult, ExceptionHandler<? super LdapException> onException) {
        this.wrappedPromise.thenOnResultOrException(onResult, onException);
        return this;
    }

    @Override
    public LdapPromise<R> thenAlways(Runnable onResultOrException) {
        this.wrappedPromise.thenAlways(onResultOrException);
        return this;
    }

    @Override
    public <VOUT> LdapPromise<VOUT> thenAsync(AsyncFunction<? super R, VOUT, LdapException> onResult) {
        return LdapPromises.wrap(this.wrappedPromise.thenAsync(onResult), this.getRequestId());
    }

    @Override
    public <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> thenAsync(AsyncFunction<? super R, VOUT, EOUT> onResult, AsyncFunction<? super LdapException, VOUT, EOUT> onException) {
        return this.wrappedPromise.thenAsync(onResult, onException);
    }

    @Override
    public <VOUT, EOUT extends Exception> Promise<VOUT, EOUT> thenAsync(AsyncFunction<? super R, VOUT, EOUT> onResult, AsyncFunction<? super LdapException, VOUT, EOUT> onException, AsyncFunction<? super RuntimeException, VOUT, EOUT> onRuntimeException) {
        return this.wrappedPromise.thenAsync(onResult, onException, onRuntimeException);
    }

    @Override
    public <EOUT extends Exception> Promise<R, EOUT> thenCatch(Function<? super LdapException, R, EOUT> onException) {
        return this.wrappedPromise.thenCatch(onException);
    }

    @Override
    public Promise<R, LdapException> thenCatchRuntimeException(Function<? super RuntimeException, R, LdapException> onRuntimeException) {
        return this.wrappedPromise.thenCatchRuntimeException(onRuntimeException);
    }

    @Override
    public Promise<R, LdapException> thenCatchRuntimeExceptionAsync(AsyncFunction<? super RuntimeException, R, LdapException> onRuntimeException) {
        return this.wrappedPromise.thenCatchRuntimeExceptionAsync(onRuntimeException);
    }

    @Override
    public LdapPromise<R> thenFinally(Runnable onResultOrException) {
        this.wrappedPromise.thenFinally(onResultOrException);
        return this;
    }

    @Override
    public <EOUT extends Exception> Promise<R, EOUT> thenCatchAsync(AsyncFunction<? super LdapException, R, EOUT> onException) {
        return this.wrappedPromise.thenCatchAsync(onException);
    }

    public P getWrappedPromise() {
        return this.wrappedPromise;
    }
}

