/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageDescriptor;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class NameForm
extends AbstractSchemaElement {
    private final boolean isObsolete;
    private final List<String> names;
    private final String oid;
    private final Set<String> optionalAttributeOids;
    private Set<AttributeType> optionalAttributes = Collections.emptySet();
    private final Set<String> requiredAttributeOids;
    private Set<AttributeType> requiredAttributes = Collections.emptySet();
    private ObjectClass structuralClass;
    private final String structuralClassOid;

    private NameForm(Builder builder) {
        super(builder);
        if (builder.oid == null || builder.oid.isEmpty()) {
            throw new IllegalArgumentException("An OID must be specified.");
        }
        if (builder.structuralObjectClassOid == null || builder.structuralObjectClassOid.isEmpty()) {
            throw new IllegalArgumentException("A structural class OID must be specified.");
        }
        if (builder.requiredAttributes == null || builder.requiredAttributes.isEmpty()) {
            throw new IllegalArgumentException("Required attribute must be specified.");
        }
        this.oid = builder.oid;
        this.structuralClassOid = builder.structuralObjectClassOid;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.requiredAttributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.requiredAttributes);
        this.optionalAttributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.optionalAttributes);
        this.isObsolete = builder.isObsolete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof NameForm) {
            NameForm other = (NameForm)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public String getNameOrOid() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getOid() {
        return this.oid;
    }

    public Set<AttributeType> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public Set<AttributeType> getRequiredAttributes() {
        return this.requiredAttributes;
    }

    public ObjectClass getStructuralClass() {
        return this.structuralClass;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOid(String nameOrOid) {
        return this.hasName(nameOrOid) || this.getOid().equals(nameOrOid);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOptional(AttributeType attributeType) {
        return this.optionalAttributes.contains(attributeType);
    }

    public boolean isRequired(AttributeType attributeType) {
        return this.requiredAttributes.contains(attributeType);
    }

    public boolean isRequiredOrOptional(AttributeType attributeType) {
        return this.isRequired(attributeType) || this.isOptional(attributeType);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        buffer.append(" OC ");
        buffer.append(this.structuralClassOid);
        if (!this.requiredAttributeOids.isEmpty()) {
            iterator = this.requiredAttributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MUST ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MUST ");
                buffer.append(firstName);
            }
        }
        if (!this.optionalAttributeOids.isEmpty()) {
            iterator = this.optionalAttributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" MAY ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" MAY ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        try {
            this.structuralClass = schema.getObjectClass(this.structuralClassOid);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_STRUCTURAL_CLASS1.get(this.getNameOrOid(), this.structuralClassOid);
            throw new SchemaException(message, (Throwable)e);
        }
        if (this.structuralClass.getObjectClassType() != ObjectClassType.STRUCTURAL) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_STRUCTURAL_CLASS_NOT_STRUCTURAL1.get(this.getNameOrOid(), this.structuralClass.getNameOrOid(), (Object)this.structuralClass.getObjectClassType());
            throw new SchemaException(message);
        }
        if (!this.isObsolete() && this.structuralClass.isObsolete()) {
            warnings.add(CoreMessages.WARN_NAME_FORM_HAS_OBSOLETE_STRUCTURAL_CLASS.get(this.getNameOrOid(), this.structuralClassOid));
        }
        this.requiredAttributes = this.getAttributeTypes(schema, this.requiredAttributeOids, CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_REQUIRED_ATTR1, warnings, CoreMessages.WARN_NAME_FORM_HAS_OBSOLETE_REQUIRED_ATTR);
        if (!this.optionalAttributeOids.isEmpty()) {
            this.optionalAttributes = this.getAttributeTypes(schema, this.optionalAttributeOids, CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_UNKNOWN_OPTIONAL_ATTR1, warnings, CoreMessages.WARN_NAME_FORM_HAS_OBSOLETE_OPTIONAL_ATTR);
        }
        this.optionalAttributes = Collections.unmodifiableSet(this.optionalAttributes);
        this.requiredAttributes = Collections.unmodifiableSet(this.requiredAttributes);
    }

    private Set<AttributeType> getAttributeTypes(Schema schema, Set<String> oids, LocalizableMessageDescriptor.Arg2<Object, Object> unknownElementErrorMsg, List<LocalizableMessage> warnings, LocalizableMessageDescriptor.Arg2<Object, Object> obsoleteElementMsg) throws SchemaException {
        HashSet<AttributeType> attrTypes = new HashSet<AttributeType>(oids.size());
        for (String oid : oids) {
            AttributeType attributeType;
            try {
                attributeType = schema.getAttributeType(oid);
                attrTypes.add(attributeType);
            }
            catch (UnknownSchemaElementException e) {
                throw new SchemaException(unknownElementErrorMsg.get(this.getNameOrOid(), oid), (Throwable)e);
            }
            if (this.isObsolete() || !attributeType.isObsolete()) continue;
            warnings.add(obsoleteElementMsg.get(this.getNameOrOid(), oid));
        }
        return attrTypes;
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private boolean isObsolete;
        private final List<String> names = new LinkedList<String>();
        private String oid;
        private final Set<String> optionalAttributes = new LinkedHashSet<String>();
        private final Set<String> requiredAttributes = new LinkedHashSet<String>();
        private String structuralObjectClassOid;

        Builder(NameForm nf, SchemaBuilder builder) {
            super(builder, nf);
            this.oid = nf.oid;
            this.structuralObjectClassOid = nf.structuralClassOid;
            this.isObsolete = nf.isObsolete;
            this.names.addAll(nf.names);
            this.requiredAttributes.addAll(nf.requiredAttributeOids);
            this.optionalAttributes.addAll(nf.optionalAttributeOids);
        }

        Builder(String oid, SchemaBuilder builder) {
            super(builder);
            this.oid(oid);
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addNameForm(new NameForm(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addNameForm(new NameForm(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public Builder optionalAttributes(Collection<String> nameOrOids) {
            this.optionalAttributes.addAll(nameOrOids);
            return this;
        }

        public Builder optionalAttributes(String ... nameOrOids) {
            return this.optionalAttributes(Arrays.asList(nameOrOids));
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        public Builder removeAllOptionalAttributes() {
            this.optionalAttributes.clear();
            return this;
        }

        public Builder removeAllRequiredAttributes() {
            this.requiredAttributes.clear();
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }

        public Builder removeOptionalAttribute(String nameOrOid) {
            this.optionalAttributes.remove(nameOrOid);
            return this;
        }

        public Builder removeRequiredAttribute(String nameOrOid) {
            this.requiredAttributes.remove(nameOrOid);
            return this;
        }

        public Builder requiredAttributes(Collection<String> nameOrOids) {
            this.requiredAttributes.addAll(nameOrOids);
            return this;
        }

        public Builder requiredAttributes(String ... nameOrOids) {
            return this.requiredAttributes(Arrays.asList(nameOrOids));
        }

        public Builder structuralObjectClassOid(String nameOrOid) {
            this.structuralObjectClassOid = nameOrOid;
            return this;
        }

        @Override
        Builder getThis() {
            return this;
        }
    }
}

