/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.schema.AbstractSchemaElement;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;
import org.forgerock.util.Reject;

public final class MatchingRuleUse
extends AbstractSchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> attributeOids;
    private MatchingRule matchingRule;
    private Set<AttributeType> attributes = Collections.emptySet();

    private MatchingRuleUse(Builder builder) {
        super(builder);
        Reject.ifNull(builder.oid);
        this.oid = builder.oid;
        this.names = SchemaUtils.unmodifiableCopyOfList(builder.names);
        this.isObsolete = builder.isObsolete;
        this.attributeOids = SchemaUtils.unmodifiableCopyOfSet(builder.attributeOids);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchingRuleUse) {
            MatchingRuleUse other = (MatchingRuleUse)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public Set<AttributeType> getAttributes() {
        return this.attributes;
    }

    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    public String getMatchingRuleOid() {
        return this.oid;
    }

    public String getNameOrOid() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        return this.attributes.contains(attributeType);
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOid(String value) {
        return this.hasName(value) || this.oid.equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        this.appendDescription(buffer);
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.attributeOids.isEmpty()) {
            iterator = this.attributeOids.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" APPLIES ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" APPLIES ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        try {
            this.matchingRule = schema.getMatchingRule(this.oid);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_MATCHING_RULE1.get(this.getNameOrOid(), this.oid);
            throw new SchemaException(message, (Throwable)e);
        }
        if (!this.isObsolete() && this.matchingRule.isObsolete()) {
            warnings.add(CoreMessages.WARN_MATCHING_RULE_USE_HAS_OBSOLETE_MATCHING_RULE.get(this.getNameOrOid(), this.oid));
        }
        this.attributes = new HashSet<AttributeType>(this.attributeOids.size());
        for (String attribute : this.attributeOids) {
            AttributeType attributeType;
            try {
                attributeType = schema.getAttributeType(attribute);
                this.attributes.add(attributeType);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_ATTR1.get(this.getNameOrOid(), attribute);
                throw new SchemaException(message, (Throwable)e);
            }
            if (this.isObsolete() || !attributeType.isObsolete()) continue;
            warnings.add(CoreMessages.WARN_MATCHING_RULE_USE_HAS_OBSOLETE_ATTR.get(this.getNameOrOid(), attribute));
        }
        this.attributes = Collections.unmodifiableSet(this.attributes);
    }

    public static final class Builder
    extends AbstractSchemaElement.SchemaElementBuilder<Builder> {
        private String oid;
        private final List<String> names = new LinkedList<String>();
        private boolean isObsolete;
        private final Set<String> attributeOids = new LinkedHashSet<String>();

        Builder(MatchingRuleUse mru, SchemaBuilder builder) {
            super(builder, mru);
            this.oid = mru.oid;
            this.names.addAll(mru.names);
            this.isObsolete = mru.isObsolete;
            this.attributeOids.addAll(mru.attributeOids);
        }

        Builder(String oid, SchemaBuilder builder) {
            super(builder);
            this.oid = oid;
        }

        public SchemaBuilder addToSchema() {
            return this.getSchemaBuilder().addMatchingRuleUse(new MatchingRuleUse(this), false);
        }

        public SchemaBuilder addToSchemaOverwrite() {
            return this.getSchemaBuilder().addMatchingRuleUse(new MatchingRuleUse(this), true);
        }

        SchemaBuilder addToSchema(boolean overwrite) {
            return overwrite ? this.addToSchemaOverwrite() : this.addToSchema();
        }

        public Builder attributes(Collection<String> attributeOids) {
            this.attributeOids.addAll(attributeOids);
            return this;
        }

        public Builder attributes(String ... attributeOids) {
            this.attributeOids.addAll(Arrays.asList(attributeOids));
            return this;
        }

        @Override
        public Builder description(String description) {
            return (Builder)this.description0(description);
        }

        @Override
        public Builder extraProperties(Map<String, List<String>> extraProperties) {
            return (Builder)this.extraProperties0(extraProperties);
        }

        @Override
        public Builder extraProperties(String extensionName, String ... extensionValues) {
            return (Builder)this.extraProperties0(extensionName, extensionValues);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public Builder names(Collection<String> names) {
            this.names.addAll(names);
            return this;
        }

        public Builder names(String ... names) {
            return this.names(Arrays.asList(names));
        }

        public Builder obsolete(boolean isObsolete) {
            this.isObsolete = isObsolete;
            return this;
        }

        public Builder oid(String oid) {
            this.oid = oid;
            return this;
        }

        public Builder removeAllAttributes() {
            this.attributeOids.clear();
            return this;
        }

        @Override
        public Builder removeAllExtraProperties() {
            return (Builder)this.removeAllExtraProperties0();
        }

        public Builder removeAllNames() {
            this.names.clear();
            return this;
        }

        public Builder removeAttribute(String attributeOid) {
            this.attributeOids.remove(attributeOid);
            return this;
        }

        @Override
        public Builder removeExtraProperty(String extensionName, String ... extensionValues) {
            return (Builder)this.removeExtraProperty0(extensionName, extensionValues);
        }

        public Builder removeName(String name) {
            this.names.remove(name);
            return this;
        }
    }
}

