/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.GserParser;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class CertificateExactMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private static final String GSER_ID_SERIALNUMBER = "serialNumber";
    private static final String GSER_ID_ISSUER = "issuer";
    private static final String GSER_ID_RDNSEQUENCE = "rdnSequence";

    CertificateExactMatchingRuleImpl() {
        super("certificateExactMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String dnstring;
        BigInteger serialNumber;
        try {
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream inputStream = new ByteArrayInputStream(value.toByteArray());
            X509Certificate certValue = (X509Certificate)certFactory.generateCertificate(inputStream);
            serialNumber = certValue.getSerialNumber();
            X500Principal issuer = certValue.getIssuerX500Principal();
            dnstring = issuer.getName("RFC2253");
        }
        catch (CertificateException ce) {
            LocalizableMessage message = CoreMessages.ERR_MR_CERTIFICATE_MATCH_PARSE_ERROR.get(ce.getMessage());
            logger.trace(message);
            return value.toByteString();
        }
        ByteString certificateIssuer = this.normalizeDN(schema, dnstring);
        return CertificateExactMatchingRuleImpl.createEncodedValue(serialNumber, certificateIssuer);
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        String dnstring;
        BigInteger serialNumber;
        GserParser parser = new GserParser(value.toString());
        try {
            parser.readStartSequence();
        }
        catch (DecodeException e) {
            logger.traceException(e);
            return this.defaultAssertion(this.normalizeAttributeValue(schema, value));
        }
        try {
            String identifier = parser.nextNamedValueIdentifier();
            if (!GSER_ID_SERIALNUMBER.equals(identifier)) {
                throw DecodeException.error(CoreMessages.ERR_MR_CERTIFICATE_MATCH_IDENTIFIER_NOT_FOUND.get(GSER_ID_SERIALNUMBER));
            }
            serialNumber = parser.nextBigInteger();
            parser.skipSeparator();
            identifier = parser.nextNamedValueIdentifier();
            if (!GSER_ID_ISSUER.equals(identifier)) {
                throw DecodeException.error(CoreMessages.ERR_MR_CERTIFICATE_MATCH_IDENTIFIER_NOT_FOUND.get(GSER_ID_ISSUER));
            }
            identifier = parser.nextChoiceValueIdentifier();
            if (!GSER_ID_RDNSEQUENCE.equals(identifier)) {
                throw DecodeException.error(CoreMessages.ERR_MR_CERTIFICATE_MATCH_IDENTIFIER_NOT_FOUND.get(GSER_ID_RDNSEQUENCE));
            }
            dnstring = parser.nextString();
            parser.readEndSequence();
            if (parser.hasNext()) {
                LocalizableMessage message = CoreMessages.ERR_MR_CERTIFICATE_MATCH_EXPECTED_END.get();
                throw DecodeException.error(message);
            }
        }
        catch (DecodeException e) {
            LocalizableMessage message = CoreMessages.ERR_MR_CERTIFICATE_MATCH_GSER_INVALID.get(StaticUtils.getExceptionMessage(e));
            throw DecodeException.error(message);
        }
        ByteString certificateIssuer = this.normalizeDN(schema, dnstring);
        return this.defaultAssertion(CertificateExactMatchingRuleImpl.createEncodedValue(serialNumber, certificateIssuer));
    }

    private ByteString normalizeDN(Schema schema, String dnstring) throws DecodeException {
        try {
            Dn dn = Dn.valueOf(dnstring, schema.asNonStrictSchema());
            return dn.toNormalizedByteString();
        }
        catch (Exception e) {
            logger.traceException(e);
            LocalizableMessage message = CoreMessages.ERR_MR_CERTIFICATE_MATCH_INVALID_DN.get(dnstring, StaticUtils.getExceptionMessage(e));
            throw DecodeException.error(message);
        }
    }

    private static ByteString createEncodedValue(BigInteger serial, ByteString issuerDN) {
        return new ByteStringBuilder().appendBytes(issuerDN).appendByte(0).appendBytes(serial.toByteArray()).toByteString();
    }
}

