/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.util.Reject;

final class SearchRequestImpl
extends AbstractProtocolOpImpl<SearchRequest>
implements SearchRequest {
    private final List<String> attributes = new LinkedList<String>();
    private DereferenceAliasesPolicy dereferenceAliasesPolicy = DereferenceAliasesPolicy.NEVER;
    private Filter filter;
    private Dn name;
    private SearchScope scope;
    private int sizeLimit;
    private int timeLimit;
    private boolean typesOnly;

    SearchRequestImpl(Dn name, SearchScope scope, Filter filter) {
        this.name = name;
        this.scope = scope;
        this.filter = filter;
    }

    SearchRequestImpl(SearchRequest searchRequest) {
        super(searchRequest);
        this.attributes.addAll(searchRequest.getAttributes());
        this.name = searchRequest.getName();
        this.dereferenceAliasesPolicy = searchRequest.getDereferenceAliasesPolicy();
        this.filter = searchRequest.getFilter();
        this.scope = searchRequest.getScope();
        this.sizeLimit = searchRequest.getSizeLimit();
        this.timeLimit = searchRequest.getTimeLimit();
        this.typesOnly = searchRequest.isTypesOnly();
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public SearchRequest addAttribute(String ... attributeDescriptions) {
        for (String attributeDescription : attributeDescriptions) {
            this.attributes.add(Reject.checkNotNull(attributeDescription));
        }
        return this;
    }

    @Override
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    public DereferenceAliasesPolicy getDereferenceAliasesPolicy() {
        return this.dereferenceAliasesPolicy;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public Dn getName() {
        return this.name;
    }

    @Override
    public SearchScope getScope() {
        return this.scope;
    }

    @Override
    public int getSizeLimit() {
        return this.sizeLimit;
    }

    @Override
    public boolean isSingleEntrySearch() {
        return this.sizeLimit == 1 || SearchScope.BASE_OBJECT.equals(this.scope);
    }

    @Override
    public int getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    @Override
    public SearchRequest setDereferenceAliasesPolicy(DereferenceAliasesPolicy policy) {
        Reject.ifNull(policy);
        this.dereferenceAliasesPolicy = policy;
        return this;
    }

    @Override
    public SearchRequest setFilter(Filter filter) {
        Reject.ifNull(filter);
        this.filter = filter;
        return this;
    }

    @Override
    public SearchRequest setFilter(String filter) {
        this.filter = Filter.valueOf(filter);
        return this;
    }

    @Override
    public SearchRequest setName(Dn dn) {
        Reject.ifNull(dn);
        this.name = dn;
        return this;
    }

    @Override
    public SearchRequest setName(String dn) {
        Reject.ifNull(dn);
        this.name = Dn.valueOf(dn);
        return this;
    }

    @Override
    public SearchRequest setScope(SearchScope scope) {
        Reject.ifNull(scope);
        this.scope = scope;
        return this;
    }

    @Override
    public SearchRequest setSizeLimit(int limit) {
        if (limit < 0) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_NEGATIVE_SIZE_LIMIT.get(limit));
        }
        this.sizeLimit = limit;
        return this;
    }

    @Override
    public SearchRequest setTimeLimit(int limit) {
        if (limit < 0) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_NEGATIVE_TIME_LIMIT.get(limit));
        }
        this.timeLimit = limit;
        return this;
    }

    @Override
    public SearchRequest setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
        return this;
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.SEARCH;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SearchRequest(name=").append(this.getName());
        builder.append(", scope=").append(this.getScope());
        builder.append(", dereferenceAliasesPolicy=").append(this.getDereferenceAliasesPolicy());
        if (this.getSizeLimit() != 0) {
            builder.append(", sizeLimit=").append(this.getSizeLimit());
        }
        if (this.getTimeLimit() != 0) {
            builder.append(", timeLimit=").append(this.getTimeLimit());
        }
        builder.append(", typesOnly=").append(this.isTypesOnly());
        builder.append(", filter=").append(this.getFilter());
        if (!this.getAttributes().isEmpty()) {
            builder.append(", attributes=").append(this.getAttributes());
        }
        if (!this.getControls().isEmpty()) {
            builder.append(", controls=").append(this.getControls());
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    SearchRequest getThis() {
        return this;
    }
}

