/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.LinkedHashMapEntry;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.BindResultImpl;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.CompareResultImpl;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;
import org.forgerock.opendj.ldap.messages.GenericExtendedResultImpl;
import org.forgerock.opendj.ldap.messages.GenericIntermediateResponse;
import org.forgerock.opendj.ldap.messages.GenericIntermediateResponseImpl;
import org.forgerock.opendj.ldap.messages.PasswordModifyExtendedResult;
import org.forgerock.opendj.ldap.messages.PasswordModifyExtendedResultImpl;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.ResultImpl;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultEntryImpl;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.messages.SearchResultReferenceImpl;
import org.forgerock.opendj.ldap.messages.StartTlsExtendedResult;
import org.forgerock.opendj.ldap.messages.StartTlsExtendedResultmpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableBindResultImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableCompareResultImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableGenericExtendedResultImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableGenericIntermediateResponseImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiablePasswordModifyExtendedResultImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableResultImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableSearchResultEntryImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableSearchResultReferenceImpl;
import org.forgerock.opendj.ldap.messages.UnmodifiableWhoAmIExtendedResultImpl;
import org.forgerock.opendj.ldap.messages.WhoAmIExtendedResult;
import org.forgerock.opendj.ldap.messages.WhoAmIExtendedResultImpl;
import org.forgerock.util.Reject;

public final class Responses {
    public static BindResult copyOfBindResult(BindResult result) {
        return new BindResultImpl(result);
    }

    public static CompareResult copyOfCompareResult(CompareResult result) {
        return new CompareResultImpl(result);
    }

    public static GenericExtendedResult copyOfGenericExtendedResult(GenericExtendedResult result) {
        return new GenericExtendedResultImpl(result);
    }

    public static GenericIntermediateResponse copyOfGenericIntermediateResponse(GenericIntermediateResponse result) {
        return new GenericIntermediateResponseImpl(result);
    }

    public static PasswordModifyExtendedResult copyOfPasswordModifyExtendedResult(PasswordModifyExtendedResult result) {
        return new PasswordModifyExtendedResultImpl(result);
    }

    public static Result copyOfResult(Result result) {
        return new ResultImpl(result);
    }

    public static SearchResultEntry copyOfSearchResultEntry(SearchResultEntry entry) {
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultReference copyOfSearchResultReference(SearchResultReference reference) {
        return new SearchResultReferenceImpl(reference);
    }

    public static WhoAmIExtendedResult copyOfWhoAmIExtendedResult(WhoAmIExtendedResult result) {
        return new WhoAmIExtendedResultImpl(result);
    }

    public static BindResult newBindResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new BindResultImpl(resultCode);
    }

    public static CompareResult newCompareResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new CompareResultImpl(resultCode);
    }

    public static GenericExtendedResult newGenericExtendedResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new GenericExtendedResultImpl(resultCode);
    }

    public static GenericIntermediateResponse newGenericIntermediateResponse() {
        return new GenericIntermediateResponseImpl();
    }

    public static GenericIntermediateResponse newGenericIntermediateResponse(String responseName, Object responseValue) {
        return new GenericIntermediateResponseImpl().setOid(responseName).setValue(responseValue);
    }

    public static PasswordModifyExtendedResult newPasswordModifyExtendedResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new PasswordModifyExtendedResultImpl(resultCode);
    }

    public static Result newResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new ResultImpl(resultCode);
    }

    public static SearchResultEntry newSearchResultEntry(Dn name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultEntry newSearchResultEntry(Entry entry) {
        Reject.ifNull(entry);
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultEntry newSearchResultEntry(String name) {
        Entry entry = new LinkedHashMapEntry().setName(name);
        return new SearchResultEntryImpl(entry);
    }

    public static SearchResultEntry newSearchResultEntry(String ... ldifLines) {
        return Responses.newSearchResultEntry(new LinkedHashMapEntry(ldifLines));
    }

    public static SearchResultReference newSearchResultReference(String uri) {
        Reject.ifNull(uri);
        return new SearchResultReferenceImpl(uri);
    }

    public static StartTlsExtendedResult newStartTlsExtendedResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new StartTlsExtendedResultmpl(resultCode);
    }

    public static WhoAmIExtendedResult newWhoAmIExtendedResult(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        return new WhoAmIExtendedResultImpl(ResultCode.SUCCESS);
    }

    public static BindResult unmodifiableBindResult(BindResult result) {
        if (result instanceof UnmodifiableBindResultImpl) {
            return result;
        }
        return new UnmodifiableBindResultImpl(result);
    }

    public static CompareResult unmodifiableCompareResult(CompareResult result) {
        if (result instanceof UnmodifiableCompareResultImpl) {
            return result;
        }
        return new UnmodifiableCompareResultImpl(result);
    }

    public static GenericExtendedResult unmodifiableGenericExtendedResult(GenericExtendedResult result) {
        if (result instanceof UnmodifiableGenericExtendedResultImpl) {
            return result;
        }
        return new UnmodifiableGenericExtendedResultImpl(result);
    }

    public static GenericIntermediateResponse unmodifiableGenericIntermediateResponse(GenericIntermediateResponse response) {
        if (response instanceof UnmodifiableGenericIntermediateResponseImpl) {
            return response;
        }
        return new UnmodifiableGenericIntermediateResponseImpl(response);
    }

    public static PasswordModifyExtendedResult unmodifiablePasswordModifyExtendedResult(PasswordModifyExtendedResult result) {
        if (result instanceof UnmodifiablePasswordModifyExtendedResultImpl) {
            return result;
        }
        return new UnmodifiablePasswordModifyExtendedResultImpl(result);
    }

    public static Result unmodifiableResult(Result result) {
        if (result instanceof UnmodifiableResultImpl) {
            return result;
        }
        return new UnmodifiableResultImpl(result);
    }

    public static SearchResultEntry unmodifiableSearchResultEntry(SearchResultEntry entry) {
        if (entry instanceof UnmodifiableSearchResultEntryImpl) {
            return entry;
        }
        return new UnmodifiableSearchResultEntryImpl(entry);
    }

    public static SearchResultReference unmodifiableSearchResultReference(SearchResultReference reference) {
        if (reference instanceof UnmodifiableSearchResultReferenceImpl) {
            return reference;
        }
        return new UnmodifiableSearchResultReferenceImpl(reference);
    }

    public static WhoAmIExtendedResult unmodifiableWhoAmIExtendedResult(WhoAmIExtendedResult result) {
        if (result instanceof UnmodifiableSearchResultReferenceImpl) {
            return result;
        }
        return new UnmodifiableWhoAmIExtendedResultImpl(result);
    }

    private Responses() {
    }
}

