/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import java.util.Collections;
import java.util.List;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;

public final class InvalidRequest
implements Request {
    private final Request.RequestType invalidRequestType;
    private final String rawDn;
    private final LdapException reason;

    InvalidRequest(Request.RequestType invalidRequestType, String rawDn, LdapException reason) {
        this.invalidRequestType = invalidRequestType;
        this.rawDn = rawDn;
        this.reason = reason;
    }

    public Request.RequestType getInvalidRequestType() {
        return this.invalidRequestType;
    }

    public String getRawDn() {
        return this.rawDn;
    }

    public LdapException getReason() {
        return this.reason;
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.INVALID;
    }

    @Override
    public <C extends Control> C getControl(ControlDecoder<C> decoder, DecodeOptions options) throws DecodeException {
        return null;
    }

    @Override
    public List<Control> getControls() {
        return Collections.emptyList();
    }

    @Override
    public boolean containsControl(String oid) {
        return false;
    }

    @Override
    public Request addControl(Control control) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "InvalidRequest(invalidRequestType=" + (Object)((Object)this.invalidRequestType) + ", reason=" + this.reason.getMessage() + ")";
    }
}

