/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.RequestVisitor;

public abstract class AbstractExtendedRequest<R extends ExtendedRequest<S>, S extends ExtendedResult>
extends AbstractProtocolOpImpl<R>
implements ExtendedRequest<S> {
    protected AbstractExtendedRequest() {
    }

    protected AbstractExtendedRequest(ExtendedRequest<S> extendedRequest) {
        super(extendedRequest);
    }

    @Override
    public <R, P, E extends Exception> R accept(RequestVisitor<R, P, E> v, P p) throws E {
        return v.visitRequest(p, this);
    }

    @Override
    public abstract String getOid();

    @Override
    public abstract ExtendedResultDecoder<S> getResultDecoder();

    @Override
    public abstract ByteString getValue();

    @Override
    public abstract boolean hasValue();

    @Override
    public Request.RequestType getType() {
        return Request.RequestType.EXTENDED;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExtendedRequest(requestName=");
        builder.append(this.getOid());
        if (this.hasValue()) {
            builder.append(", requestValue=");
            builder.append(this.getValue().toHexPlusAsciiString(4));
        }
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    final R getThis() {
        return (R)this;
    }
}

