/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class VirtualListViewResponseControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.10";
    public static final ControlDecoder<VirtualListViewResponseControl> DECODER = new ControlDecoder<VirtualListViewResponseControl>(){

        @Override
        public VirtualListViewResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof VirtualListViewResponseControl) {
                return (VirtualListViewResponseControl)control;
            }
            if (!control.getOid().equals(VirtualListViewResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_VLVRES_CONTROL_BAD_OID.get(control.getOid(), VirtualListViewResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.INFO_VLVRES_CONTROL_NO_VALUE.get();
                throw DecodeException.error(message);
            }
            Asn1Reader reader = Asn1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                int targetPosition = (int)reader.readInteger();
                int contentCount = (int)reader.readInteger();
                ResultCode result = ResultCode.valueOf(reader.readEnumerated());
                ByteString contextID = null;
                if (reader.hasNextElement()) {
                    contextID = reader.readOctetString();
                }
                return new VirtualListViewResponseControl(control.isCritical(), targetPosition, contentCount, result, contextID);
            }
            catch (IOException e) {
                LocalizableMessage message = CoreMessages.INFO_VLVRES_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
        }

        @Override
        public String getOid() {
            return VirtualListViewResponseControl.OID;
        }
    };
    private final int targetPosition;
    private final int contentCount;
    private final ResultCode result;
    private final ByteString contextId;
    private final boolean isCritical;

    public static VirtualListViewResponseControl newControl(int targetPosition, int contentCount, ResultCode result, ByteString contextId) {
        Reject.ifNull(result);
        Reject.ifFalse(targetPosition >= 0, "targetPosition is less than 0");
        Reject.ifFalse(contentCount >= 0, "contentCount is less than 0");
        return new VirtualListViewResponseControl(false, targetPosition, contentCount, result, contextId);
    }

    private VirtualListViewResponseControl(boolean isCritical, int targetPosition, int contentCount, ResultCode result, ByteString contextId) {
        this.isCritical = isCritical;
        this.targetPosition = targetPosition;
        this.contentCount = contentCount;
        this.result = result;
        this.contextId = contextId;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public ByteString getContextId() {
        return this.contextId;
    }

    @Override
    public String getOid() {
        return OID;
    }

    public ResultCode getResult() {
        return this.result;
    }

    public int getTargetPosition() {
        return this.targetPosition;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.targetPosition);
            writer.writeInteger(this.contentCount);
            writer.writeEnumerated(this.result.intValue());
            if (this.contextId != null) {
                writer.writeOctetString(this.contextId);
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VirtualListViewResponseControl(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", targetPosition=");
        builder.append(this.targetPosition);
        builder.append(", contentCount=");
        builder.append(this.contentCount);
        builder.append(", result=");
        builder.append(this.result);
        if (this.contextId != null) {
            builder.append(", contextID=");
            builder.append(this.contextId);
        }
        builder.append(")");
        return builder.toString();
    }
}

