/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class VirtualListViewRequestControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.9";
    public static final ControlDecoder<VirtualListViewRequestControl> DECODER = new ControlDecoder<VirtualListViewRequestControl>(){

        @Override
        public VirtualListViewRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof VirtualListViewRequestControl) {
                return (VirtualListViewRequestControl)control;
            }
            if (!control.getOid().equals(VirtualListViewRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_VLVREQ_CONTROL_BAD_OID.get(control.getOid(), VirtualListViewRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.INFO_VLVREQ_CONTROL_NO_VALUE.get();
                throw DecodeException.error(message);
            }
            Asn1Reader reader = Asn1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                int beforeCount = (int)reader.readInteger();
                int afterCount = (int)reader.readInteger();
                int offset = -1;
                int contentCount = -1;
                ByteString assertionValue = null;
                byte targetType = reader.peekType();
                switch (targetType) {
                    case -96: {
                        reader.readStartSequence();
                        offset = (int)reader.readInteger();
                        contentCount = (int)reader.readInteger();
                        reader.readEndSequence();
                        break;
                    }
                    case -127: {
                        assertionValue = reader.readOctetString();
                        break;
                    }
                    default: {
                        LocalizableMessage message = CoreMessages.INFO_VLVREQ_CONTROL_INVALID_TARGET_TYPE.get(StaticUtils.byteToHex(targetType));
                        throw DecodeException.error(message);
                    }
                }
                ByteString contextID = null;
                if (reader.hasNextElement()) {
                    contextID = reader.readOctetString();
                }
                return new VirtualListViewRequestControl(control.isCritical(), beforeCount, afterCount, contentCount, offset, assertionValue, contextID);
            }
            catch (IOException e) {
                LocalizableMessage message = CoreMessages.INFO_VLVREQ_CONTROL_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
        }

        @Override
        public String getOid() {
            return VirtualListViewRequestControl.OID;
        }
    };
    private static final byte TYPE_TARGET_BYOFFSET = -96;
    private static final byte TYPE_TARGET_GREATERTHANOREQUAL = -127;
    private final int beforeCount;
    private final int afterCount;
    private final ByteString contextId;
    private final boolean isCritical;
    private final int contentCount;
    private final int offset;
    private final ByteString assertionValue;

    public static VirtualListViewRequestControl newAssertionControl(boolean isCritical, ByteString assertionValue, int beforeCount, int afterCount, ByteString contextId) {
        Reject.ifNull(assertionValue);
        Reject.ifFalse(beforeCount >= 0, "beforeCount is less than 0");
        Reject.ifFalse(afterCount >= 0, "afterCount is less than 0");
        return new VirtualListViewRequestControl(isCritical, beforeCount, afterCount, -1, -1, assertionValue, contextId);
    }

    public static VirtualListViewRequestControl newOffsetControl(boolean isCritical, int offset, int contentCount, int beforeCount, int afterCount, ByteString contextId) {
        Reject.ifFalse(beforeCount >= 0, "beforeCount is less than 0");
        Reject.ifFalse(afterCount >= 0, "afterCount is less than 0");
        Reject.ifFalse(offset > 0, "offset is less than 1");
        Reject.ifFalse(contentCount >= 0, "contentCount is less than 0");
        return new VirtualListViewRequestControl(isCritical, beforeCount, afterCount, contentCount, offset, null, contextId);
    }

    private VirtualListViewRequestControl(boolean isCritical, int beforeCount, int afterCount, int contentCount, int offset, ByteString assertionValue, ByteString contextId) {
        this.isCritical = isCritical;
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.contentCount = contentCount;
        this.offset = offset;
        this.assertionValue = assertionValue;
        this.contextId = contextId;
    }

    public int getAfterCount() {
        return this.afterCount;
    }

    public ByteString getAssertionValue() {
        return this.assertionValue;
    }

    public String getAssertionValueAsString() {
        return this.assertionValue != null ? this.assertionValue.toString() : null;
    }

    public int getBeforeCount() {
        return this.beforeCount;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public ByteString getContextId() {
        return this.contextId;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        Asn1Writer writer = Asn1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.beforeCount);
            writer.writeInteger(this.afterCount);
            if (this.hasTargetOffset()) {
                writer.writeStartSequence((byte)-96);
                writer.writeInteger(this.offset);
                writer.writeInteger(this.contentCount);
                writer.writeEndSequence();
            } else {
                writer.writeOctetString((byte)-127, this.assertionValue);
            }
            if (this.contextId != null) {
                writer.writeOctetString(this.contextId);
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean hasTargetOffset() {
        return this.assertionValue == null;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VirtualListViewRequestControl(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", beforeCount=");
        builder.append(this.beforeCount);
        builder.append(", afterCount=");
        builder.append(this.afterCount);
        if (this.hasTargetOffset()) {
            builder.append(", offset=");
            builder.append(this.offset);
            builder.append(", contentCount=");
            builder.append(this.contentCount);
        } else {
            builder.append(", greaterThanOrEqual=");
            builder.append(this.assertionValue);
        }
        if (this.contextId != null) {
            builder.append(", contextId=");
            builder.append(this.contextId);
        }
        builder.append(")");
        return builder.toString();
    }
}

