/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class ProxiedAuthV2RequestControl
implements Control {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    public static final String OID = "2.16.840.1.113730.3.4.18";
    private static final ProxiedAuthV2RequestControl ANONYMOUS = new ProxiedAuthV2RequestControl("");
    public static final ControlDecoder<ProxiedAuthV2RequestControl> DECODER = new ControlDecoder<ProxiedAuthV2RequestControl>(){

        @Override
        public ProxiedAuthV2RequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            String authorizationID;
            Reject.ifNull(control);
            if (control instanceof ProxiedAuthV2RequestControl) {
                return (ProxiedAuthV2RequestControl)control;
            }
            if (!control.getOid().equals(ProxiedAuthV2RequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_CONTROL_BAD_OID.get(control.getOid(), ProxiedAuthV2RequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.isCritical()) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_CONTROL_NOT_CRITICAL.get();
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            Asn1Reader reader = Asn1.getReader(control.getValue());
            try {
                authorizationID = reader.elementAvailable() ? reader.readOctetStringAsString() : control.getValue().toString();
            }
            catch (IOException e) {
                logger.debug(LocalizableMessage.raw("Unable to read exceptionID", e));
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_CANNOT_DECODE_VALUE.get(StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
            if (authorizationID.length() == 0) {
                return ANONYMOUS;
            }
            int colonIndex = authorizationID.indexOf(58);
            if (colonIndex < 0) {
                LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_INVALID_AUTHZID_TYPE.get(authorizationID);
                throw DecodeException.error(message);
            }
            return new ProxiedAuthV2RequestControl(authorizationID);
        }

        @Override
        public String getOid() {
            return ProxiedAuthV2RequestControl.OID;
        }
    };
    private final String authorizationId;

    public static ProxiedAuthV2RequestControl newControl(String authorizationId) {
        if (authorizationId.length() == 0) {
            return ANONYMOUS;
        }
        int colonIndex = authorizationId.indexOf(58);
        if (colonIndex < 0) {
            LocalizableMessage message = CoreMessages.ERR_PROXYAUTH2_INVALID_AUTHZID_TYPE.get(authorizationId);
            throw new LocalizedIllegalArgumentException(message);
        }
        return new ProxiedAuthV2RequestControl(authorizationId);
    }

    private ProxiedAuthV2RequestControl(String authorizationId) {
        this.authorizationId = authorizationId;
    }

    public String getAuthorizationId() {
        return this.authorizationId;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return ByteString.valueOfUtf8(this.authorizationId);
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ProxiedAuthorizationV2Control(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", authorizationId=\"");
        builder.append(this.authorizationId);
        builder.append("\")");
        return builder.toString();
    }
}

