/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.LoadBalancer;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldap.spi.ConnectionState;
import org.forgerock.opendj.ldap.spi.LdapPromises;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Options;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.ExceptionHandler;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.promise.ResultHandler;

final class RequestLoadBalancer
extends LoadBalancer {
    private final Function<Request, PartitionedRequest, NeverThrowsException> nextFactoryFunction;
    private final Function<Integer, Void, NeverThrowsException> endOfRequestFunction;

    RequestLoadBalancer(String loadBalancerName, Collection<? extends ConnectionFactory> factories, Options options, Function<Request, PartitionedRequest, NeverThrowsException> nextFactoryFunction, Function<Integer, Void, NeverThrowsException> endOfRequestFunction) {
        super(loadBalancerName, factories, options);
        this.nextFactoryFunction = nextFactoryFunction;
        this.endOfRequestFunction = endOfRequestFunction;
    }

    @Override
    public final Connection getConnection() throws LdapException {
        if (this.areAllFactoriesOffline()) {
            throw this.noOperationalConnectionFactoriesException();
        }
        return new ConnectionImpl();
    }

    @Override
    public final Promise<Connection, LdapException> getConnectionAsync() {
        if (this.areAllFactoriesOffline()) {
            return Promises.newExceptionPromise(this.noOperationalConnectionFactoriesException());
        }
        return Promises.newResultPromise(new ConnectionImpl());
    }

    private LdapException noOperationalConnectionFactoriesException() {
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, CoreMessages.ERR_NO_OPERATIONAL_CONNECTION_FACTORIES.get());
    }

    private static class ConnectionContext {
        private final AtomicReference<Connection> connectionHolder = new AtomicReference();
        private final LdapPromise<Connection> connectionPromise;
        private final PartitionedRequest partitionedRequest;

        ConnectionContext(LdapPromise<Connection> connectionPromise, PartitionedRequest partitionedRequest) {
            this.partitionedRequest = partitionedRequest;
            this.connectionPromise = connectionPromise;
        }

        Connection getConnection() {
            return this.connectionHolder.get();
        }

        void setConnection(Connection connection) {
            this.connectionHolder.set(connection);
        }

        LdapPromise<Connection> getConnectionPromise() {
            return this.connectionPromise;
        }

        int getServerIndex() {
            return this.partitionedRequest.getServerIndex();
        }

        Request getRequest() {
            return this.partitionedRequest.getRequest();
        }
    }

    static class PartitionedRequest {
        private final Request request;
        private final int serverIndex;

        PartitionedRequest(Request request, int serverIndex) {
            this.serverIndex = serverIndex;
            this.request = request;
        }

        Request getRequest() {
            return this.request;
        }

        int getServerIndex() {
            return this.serverIndex;
        }
    }

    private class ConnectionImpl
    extends AbstractAsynchronousConnection {
        private final ConnectionState state = new ConnectionState();

        private ConnectionImpl() {
        }

        @Override
        public String toString() {
            return RequestLoadBalancer.this.getLoadBalancerName() + "Connection";
        }

        @Override
        public LdapPromise<Void> abandonAsync(AbandonRequest request) {
            return LdapPromises.newSuccessfulLdapPromise(null);
        }

        @Override
        public LdapPromise<Result> addAsync(AddRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.addAsync((AddRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<BindResult> bindAsync(BindRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, BindResult, LdapException>(){

                @Override
                public Promise<BindResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.bindAsync((BindRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.state.notifyConnectionClosed();
        }

        @Override
        public LdapPromise<CompareResult> compareAsync(CompareRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, CompareResult, LdapException>(){

                @Override
                public Promise<CompareResult, LdapException> apply(Connection connection) throws LdapException {
                    return connection.compareAsync((CompareRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> deleteAsync(DeleteRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.deleteAsync((DeleteRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, R, LdapException>(){

                @Override
                public Promise<R, LdapException> apply(Connection connection) throws LdapException {
                    return connection.extendedRequestAsync((ExtendedRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid();
        }

        @Override
        public LdapPromise<Result> modifyAsync(ModifyRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyAsync((ModifyRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public LdapPromise<Result> modifyDnAsync(ModifyDnRequest request, final IntermediateResponseHandler intermediateResponseHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.modifyDnAsync((ModifyDnRequest)connectionContext.getRequest(), intermediateResponseHandler);
                }
            });
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public LdapPromise<Result> searchAsync(SearchRequest request, final IntermediateResponseHandler intermediateResponseHandler, final SearchResultHandler entryHandler) {
            final ConnectionContext connectionContext = this.getConnection(request);
            return this.executeRequest(connectionContext, new AsyncFunction<Connection, Result, LdapException>(){

                @Override
                public Promise<Result, LdapException> apply(Connection connection) throws LdapException {
                    return connection.searchAsync((SearchRequest)connectionContext.getRequest(), intermediateResponseHandler, entryHandler);
                }
            });
        }

        private ConnectionContext getConnection(Request request) {
            if (this.state.isClosed()) {
                throw new IllegalStateException();
            }
            PartitionedRequest partitionedRequest = (PartitionedRequest)RequestLoadBalancer.this.nextFactoryFunction.apply(request);
            try {
                ConnectionFactory factory = RequestLoadBalancer.this.getMonitoredConnectionFactory(partitionedRequest.getServerIndex());
                return new ConnectionContext(LdapPromises.asLdapPromise(factory.getConnectionAsync().thenOnException(new ExceptionHandler<LdapException>(){

                    @Override
                    public void handleException(LdapException e) {
                        ConnectionImpl.this.state.notifyConnectionError(false, e);
                    }
                })), partitionedRequest);
            }
            catch (LdapException e) {
                this.state.notifyConnectionError(false, e);
                LdapPromise<Connection> failedLdapPromise = LdapPromises.newFailedLdapPromise(e);
                return new ConnectionContext(failedLdapPromise, partitionedRequest);
            }
        }

        private <R> LdapPromise<R> executeRequest(final ConnectionContext connectionContext, AsyncFunction<Connection, R, LdapException> requestSender) {
            return connectionContext.getConnectionPromise().thenOnResult(new ResultHandler<Connection>(){

                @Override
                public void handleResult(Connection connection) {
                    connectionContext.setConnection(connection);
                }
            }).thenAsync(requestSender).thenFinally(new Runnable(){

                @Override
                public void run() {
                    Utils.closeSilently(connectionContext.getConnection());
                    RequestLoadBalancer.this.endOfRequestFunction.apply(connectionContext.getServerIndex());
                }
            });
        }
    }
}

