/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.util.Reject;

public final class GserParser {
    private final String gserValue;
    private int pos;
    private final int length;
    private static final Pattern GSER_IDENTIFIER = Pattern.compile("^([a-z]([A-Za-z0-9]|(-[A-Za-z0-9]))*)");
    private static final Pattern GSER_CHOICE_IDENTIFIER = Pattern.compile("^([a-z]([A-Za-z0-9]|(-[A-Za-z0-9]))*:)");
    private static final Pattern GSER_SP = Pattern.compile("^( *)");
    private static final Pattern GSER_MSP = Pattern.compile("^( +)");
    private static final Pattern GSER_INTEGER = Pattern.compile("^(\\d+)");
    private static final Pattern GSER_STRING = Pattern.compile("^(\"([^\"]|(\"\"))*\")");
    private static final Pattern GSER_SEQUENCE_START = Pattern.compile("^(\\{)");
    private static final Pattern GSER_SEQUENCE_END = Pattern.compile("^(\\})");
    private static final Pattern GSER_SEP = Pattern.compile("^(,)");

    public GserParser(CharSequence value) {
        Reject.checkNotNull(value);
        this.gserValue = value.toString();
        this.pos = 0;
        this.length = value.length();
    }

    public boolean hasNext() {
        return this.pos < this.length;
    }

    private boolean hasNext(Pattern pattern) {
        if (!this.hasNext()) {
            return false;
        }
        Matcher matcher = pattern.matcher(this.gserValue.substring(this.pos, this.length));
        return matcher.find();
    }

    private String next(Pattern pattern) throws DecodeException {
        Matcher matcher = pattern.matcher(this.gserValue.substring(this.pos, this.length));
        if (matcher.find() && matcher.groupCount() >= 1) {
            this.pos += matcher.end(1);
            return matcher.group(1);
        }
        LocalizableMessage msg = CoreMessages.WARN_GSER_PATTERN_NO_MATCH.get(pattern.pattern(), this.gserValue.substring(this.pos, this.length));
        throw DecodeException.error(msg);
    }

    private void skip(Pattern pattern) throws DecodeException {
        Matcher matcher = pattern.matcher(this.gserValue.substring(this.pos, this.length));
        if (matcher.find() && matcher.groupCount() >= 1) {
            this.pos += matcher.end(1);
        } else {
            LocalizableMessage msg = CoreMessages.WARN_GSER_PATTERN_NO_MATCH.get(pattern.pattern(), this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
    }

    public GserParser skipSp() throws DecodeException {
        this.skip(GSER_SP);
        return this;
    }

    public GserParser skipMsp() throws DecodeException {
        this.skip(GSER_MSP);
        return this;
    }

    public GserParser readStartSequence() throws DecodeException {
        this.next(GSER_SEQUENCE_START);
        this.skip(GSER_SP);
        return this;
    }

    public GserParser readEndSequence() throws DecodeException {
        this.skip(GSER_SP);
        this.next(GSER_SEQUENCE_END);
        return this;
    }

    public GserParser skipSeparator() throws DecodeException {
        if (!this.hasNext(GSER_SEP)) {
            LocalizableMessage msg = CoreMessages.WARN_GSER_NO_VALID_SEPARATOR.get(this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
        this.skip(GSER_SEP);
        this.skip(GSER_SP);
        return this;
    }

    public String nextString() throws DecodeException {
        if (!this.hasNext(GSER_STRING)) {
            LocalizableMessage msg = CoreMessages.WARN_GSER_NO_VALID_STRING.get(this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
        String str = this.next(GSER_STRING);
        return str.substring(1, str.length() - 1).replace("\"\"", "\"");
    }

    public int nextInteger() throws DecodeException {
        if (!this.hasNext(GSER_INTEGER)) {
            LocalizableMessage msg = CoreMessages.WARN_GSER_NO_VALID_INTEGER.get(this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
        return Integer.valueOf(this.next(GSER_INTEGER));
    }

    public BigInteger nextBigInteger() throws DecodeException {
        if (!this.hasNext(GSER_INTEGER)) {
            LocalizableMessage msg = CoreMessages.WARN_GSER_NO_VALID_INTEGER.get(this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
        return new BigInteger(this.next(GSER_INTEGER));
    }

    public String nextNamedValueIdentifier() throws DecodeException {
        if (!this.hasNext(GSER_IDENTIFIER)) {
            LocalizableMessage msg = CoreMessages.WARN_GSER_NO_VALID_IDENTIFIER.get(this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
        String identifier = this.next(GSER_IDENTIFIER);
        if (!this.hasNext(GSER_MSP)) {
            LocalizableMessage msg = CoreMessages.WARN_GSER_SPACE_CHAR_EXPECTED.get(this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
        this.skipMsp();
        return identifier;
    }

    public String nextChoiceValueIdentifier() throws DecodeException {
        if (!this.hasNext(GSER_CHOICE_IDENTIFIER)) {
            LocalizableMessage msg = CoreMessages.WARN_GSER_NO_VALID_IDENTIFIEDCHOICE.get(this.gserValue.substring(this.pos, this.length));
            throw DecodeException.error(msg);
        }
        String identifier = this.next(GSER_CHOICE_IDENTIFIER);
        return identifier.substring(0, identifier.length() - 1);
    }

    public String toString() {
        return this.gserValue;
    }
}

