/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.CoreMessages;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Base64;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteStringBuilder;

public final class ByteString
implements ByteSequence {
    private static final ByteString EMPTY = ByteString.wrap(new byte[0]);
    private final byte[] buffer;
    private final int length;
    private final int offset;

    public static ByteString empty() {
        return EMPTY;
    }

    public static ByteString valueOfInt(int i) {
        byte[] bytes = new byte[4];
        for (int j = 3; j >= 0; --j) {
            bytes[j] = (byte)i;
            i >>>= 8;
        }
        return ByteString.wrap(bytes);
    }

    public static ByteString valueOfLong(long l) {
        byte[] bytes = new byte[8];
        for (int i = 7; i >= 0; --i) {
            bytes[i] = (byte)l;
            l >>>= 8;
        }
        return ByteString.wrap(bytes);
    }

    public static ByteString valueOfObject(Object o) {
        if (o instanceof ByteSequence) {
            return ((ByteSequence)o).toByteString();
        }
        if (o instanceof byte[]) {
            return ByteString.valueOfBytes((byte[])o);
        }
        if (o instanceof char[]) {
            return ByteString.valueOfUtf8((char[])o);
        }
        return ByteString.valueOfUtf8(o.toString());
    }

    public static ByteString valueOfUtf8(CharSequence s) {
        if (s.length() == 0) {
            return EMPTY;
        }
        return ByteString.wrap(StaticUtils.getBytes(s));
    }

    public static ByteString valueOfBase64(String s) {
        if (s.length() == 0) {
            return EMPTY;
        }
        return Base64.decode(s);
    }

    public static ByteString valueOfHex(String hexString) {
        if (hexString == null || hexString.length() == 0) {
            return EMPTY;
        }
        int length = hexString.length();
        if (length % 2 != 0) {
            throw new LocalizedIllegalArgumentException(CoreMessages.ERR_HEX_DECODE_INVALID_LENGTH.get(hexString));
        }
        int arrayLength = length / 2;
        byte[] bytes = new byte[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            bytes[i] = ByteString.hexToByte(hexString, hexString.charAt(i * 2), hexString.charAt(i * 2 + 1));
        }
        return ByteString.valueOfBytes(bytes);
    }

    public static ByteString valueOfBytes(byte[] bytes) {
        if (bytes.length == 0) {
            return EMPTY;
        }
        return ByteString.wrap(Arrays.copyOf(bytes, bytes.length));
    }

    public static ByteString valueOfBytes(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        if (offset == length) {
            return EMPTY;
        }
        return ByteString.wrap(Arrays.copyOfRange(bytes, offset, offset + length));
    }

    public static ByteString valueOfUtf8(char[] chars) {
        if (chars.length == 0) {
            return EMPTY;
        }
        return ByteString.wrap(StaticUtils.getBytes(chars));
    }

    public static ByteString wrap(byte[] bytes) {
        return new ByteString(bytes, 0, bytes.length);
    }

    public static ByteString wrap(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return new ByteString(bytes, offset, length);
    }

    static void checkArrayBounds(byte[] b, int offset, int length) {
        if (offset < 0 || offset > b.length || length < 0 || offset + length > b.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    static int compareTo(byte[] b1, int offset1, int length1, byte[] b2, int offset2, int length2) {
        int count = Math.min(length1, length2);
        int i = offset1;
        int j = offset2;
        while (count-- != 0) {
            int secondByte;
            int firstByte;
            if ((firstByte = 0xFF & b1[i++]) == (secondByte = 0xFF & b2[j++])) continue;
            return firstByte - secondByte;
        }
        return length1 - length2;
    }

    static boolean equals(byte[] b1, int offset1, int length1, byte[] b2, int offset2, int length2) {
        if (length1 != length2) {
            return false;
        }
        int i = offset1;
        int j = offset2;
        int count = length1;
        while (count-- != 0) {
            if (b1[i++] == b2[j++]) continue;
            return false;
        }
        return true;
    }

    static int hashCode(byte[] b, int offset, int length) {
        int hashCode = 1;
        int i = offset;
        int count = length;
        while (count-- != 0) {
            hashCode = 31 * hashCode + b[i++];
        }
        return hashCode;
    }

    static String toString(byte[] b, int offset, int length) {
        if (length == 0) {
            return "";
        }
        try {
            return new String(b, offset, length, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to decode bytes as UTF-8 string", e);
        }
    }

    public String toAsciiString() {
        if (this.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            byte b = this.buffer[this.offset + i];
            if (StaticUtils.isPrintable(b)) {
                sb.append((char)b);
                continue;
            }
            sb.append('%');
            sb.append(StaticUtils.byteToHex(b));
        }
        return sb.toString();
    }

    private static byte hexToByte(String value, char c1, char c2) {
        byte b;
        switch (c1) {
            case '0': {
                b = 0;
                break;
            }
            case '1': {
                b = 16;
                break;
            }
            case '2': {
                b = 32;
                break;
            }
            case '3': {
                b = 48;
                break;
            }
            case '4': {
                b = 64;
                break;
            }
            case '5': {
                b = 80;
                break;
            }
            case '6': {
                b = 96;
                break;
            }
            case '7': {
                b = 112;
                break;
            }
            case '8': {
                b = -128;
                break;
            }
            case '9': {
                b = -112;
                break;
            }
            case 'A': 
            case 'a': {
                b = -96;
                break;
            }
            case 'B': 
            case 'b': {
                b = -80;
                break;
            }
            case 'C': 
            case 'c': {
                b = -64;
                break;
            }
            case 'D': 
            case 'd': {
                b = -48;
                break;
            }
            case 'E': 
            case 'e': {
                b = -32;
                break;
            }
            case 'F': 
            case 'f': {
                b = -16;
                break;
            }
            default: {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get(value, Character.valueOf(c1)));
            }
        }
        switch (c2) {
            case '0': {
                break;
            }
            case '1': {
                b = (byte)(b | 1);
                break;
            }
            case '2': {
                b = (byte)(b | 2);
                break;
            }
            case '3': {
                b = (byte)(b | 3);
                break;
            }
            case '4': {
                b = (byte)(b | 4);
                break;
            }
            case '5': {
                b = (byte)(b | 5);
                break;
            }
            case '6': {
                b = (byte)(b | 6);
                break;
            }
            case '7': {
                b = (byte)(b | 7);
                break;
            }
            case '8': {
                b = (byte)(b | 8);
                break;
            }
            case '9': {
                b = (byte)(b | 9);
                break;
            }
            case 'A': 
            case 'a': {
                b = (byte)(b | 0xA);
                break;
            }
            case 'B': 
            case 'b': {
                b = (byte)(b | 0xB);
                break;
            }
            case 'C': 
            case 'c': {
                b = (byte)(b | 0xC);
                break;
            }
            case 'D': 
            case 'd': {
                b = (byte)(b | 0xD);
                break;
            }
            case 'E': 
            case 'e': {
                b = (byte)(b | 0xE);
                break;
            }
            case 'F': 
            case 'f': {
                b = (byte)(b | 0xF);
                break;
            }
            default: {
                throw new LocalizedIllegalArgumentException(CoreMessages.ERR_HEX_DECODE_INVALID_CHARACTER.get(value, Character.valueOf(c2)));
            }
        }
        return b;
    }

    private ByteString(byte[] b, int offset, int length) {
        this.buffer = b;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public ByteSequenceReader asReader() {
        return new ByteSequenceReader(this);
    }

    @Override
    public byte byteAt(int index) {
        if (index >= this.length || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[this.offset + index];
    }

    @Override
    public int compareTo(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return ByteString.compareTo(this.buffer, this.offset, this.length, bytes, offset, length);
    }

    @Override
    public int compareTo(ByteSequence o) {
        if (this == o) {
            return 0;
        }
        return -o.compareTo(this.buffer, this.offset, this.length);
    }

    @Override
    public byte[] copyTo(byte[] bytes) {
        this.copyTo(bytes, 0);
        return bytes;
    }

    @Override
    public byte[] copyTo(byte[] bytes, int offset) {
        if (offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.buffer, this.offset, bytes, offset, Math.min(this.length, bytes.length - offset));
        return bytes;
    }

    @Override
    public ByteBuffer copyTo(ByteBuffer byteBuffer) {
        byteBuffer.put(this.buffer, this.offset, this.length);
        return byteBuffer;
    }

    @Override
    public ByteStringBuilder copyTo(ByteStringBuilder builder) {
        builder.appendBytes(this.buffer, this.offset, this.length);
        return builder;
    }

    @Override
    public boolean copyTo(CharBuffer charBuffer, CharsetDecoder decoder) {
        return ByteString.copyTo(ByteBuffer.wrap(this.buffer, this.offset, this.length), charBuffer, decoder);
    }

    static boolean copyTo(ByteBuffer inBuffer, CharBuffer outBuffer, CharsetDecoder decoder) {
        CoderResult result = decoder.decode(inBuffer, outBuffer, true);
        decoder.flush(outBuffer);
        return !result.isError() && !result.isOverflow();
    }

    @Override
    public OutputStream copyTo(OutputStream stream) throws IOException {
        stream.write(this.buffer, this.offset, this.length);
        return stream;
    }

    @Override
    public boolean equals(byte[] bytes, int offset, int length) {
        ByteString.checkArrayBounds(bytes, offset, length);
        return ByteString.equals(this.buffer, this.offset, this.length, bytes, offset, length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ByteSequence) {
            ByteSequence other = (ByteSequence)o;
            return other.equals(this.buffer, this.offset, this.length);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ByteString.hashCode(this.buffer, this.offset, this.length);
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public ByteString subSequence(int start, int end) {
        if (start < 0 || start > end || end > this.length) {
            throw new IndexOutOfBoundsException();
        }
        return new ByteString(this.buffer, this.offset + start, end - start);
    }

    @Override
    public boolean startsWith(ByteSequence prefix) {
        return prefix != null && prefix.length() <= this.length && prefix.equals(this.buffer, 0, prefix.length());
    }

    @Override
    public String toBase64String() {
        return Base64.encode(this);
    }

    public String toHexString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.length * 2);
        builder.append(StaticUtils.byteToHex(this.buffer[this.offset]));
        for (int i = 1; i < this.length; ++i) {
            builder.append(StaticUtils.byteToHex(this.buffer[this.offset + i]));
        }
        return builder.toString();
    }

    public String toPercentHexString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(this.length * 3);
        for (int i = 0; i < this.length; ++i) {
            builder.append('%');
            builder.append(StaticUtils.byteToHex(this.buffer[this.offset + i]));
        }
        return builder.toString();
    }

    public String toHexPlusAsciiString(int indent) {
        StringBuilder builder = new StringBuilder();
        StringBuilder indentBuf = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuf.append(' ');
        }
        int pos = 0;
        while (this.length - pos >= 16) {
            StringBuilder asciiBuf = new StringBuilder(17);
            byte currentByte = this.buffer[this.offset + pos];
            builder.append((CharSequence)indentBuf);
            builder.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToAscii(currentByte));
            ++pos;
            int i = 1;
            while (i < 16) {
                currentByte = this.buffer[this.offset + pos];
                builder.append(' ');
                builder.append(StaticUtils.byteToHex(currentByte));
                asciiBuf.append(StaticUtils.byteToAscii(currentByte));
                if (i == 7) {
                    builder.append("  ");
                    asciiBuf.append(' ');
                }
                ++i;
                ++pos;
            }
            builder.append("  ");
            builder.append((CharSequence)asciiBuf);
            builder.append(StaticUtils.EOL);
        }
        int remaining = this.length - pos;
        if (remaining > 0) {
            StringBuilder asciiBuf = new StringBuilder(remaining + 1);
            byte currentByte = this.buffer[this.offset + pos];
            builder.append((CharSequence)indentBuf);
            builder.append(StaticUtils.byteToHex(currentByte));
            asciiBuf.append(StaticUtils.byteToAscii(currentByte));
            ++pos;
            int i = 1;
            while (i < 16) {
                builder.append(' ');
                if (i < remaining) {
                    currentByte = this.buffer[this.offset + pos];
                    builder.append(StaticUtils.byteToHex(currentByte));
                    asciiBuf.append(StaticUtils.byteToAscii(currentByte));
                } else {
                    builder.append("  ");
                }
                if (i == 7) {
                    builder.append("  ");
                    if (i < remaining) {
                        asciiBuf.append(' ');
                    }
                }
                ++i;
                ++pos;
            }
            builder.append("  ");
            builder.append((CharSequence)asciiBuf);
            builder.append(StaticUtils.EOL);
        }
        return builder.toString();
    }

    @Override
    public byte[] toByteArray() {
        return this.copyTo(new byte[this.length]);
    }

    @Override
    public ByteString toByteString() {
        return this;
    }

    public char[] toCharArray() {
        Charset utf8 = Charset.forName("UTF-8");
        CharBuffer charBuffer = utf8.decode(ByteBuffer.wrap(this.buffer, this.offset, this.length));
        char[] chars = new char[charBuffer.remaining()];
        charBuffer.get(chars);
        return chars;
    }

    public int toInt() {
        if (this.length < 4) {
            throw new IndexOutOfBoundsException();
        }
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v <<= 8;
            v |= this.buffer[this.offset + i] & 0xFF;
        }
        return v;
    }

    public long toLong() {
        if (this.length < 8) {
            throw new IndexOutOfBoundsException();
        }
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(this.buffer[this.offset + i] & 0xFF);
        }
        return v;
    }

    @Override
    public String toString() {
        return ByteString.toString(this.buffer, this.offset, this.length);
    }
}

