/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.util.Collection;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.forgerock.util.Reject;

public abstract class AbstractConnectionWrapper<C extends Connection>
implements Connection {
    protected final C connection;

    protected AbstractConnectionWrapper(C connection) {
        Reject.ifNull(connection);
        this.connection = connection;
    }

    @Override
    public LdapPromise<Void> abandonAsync(AbandonRequest request) {
        return this.connection.abandonAsync(request);
    }

    @Override
    public Result add(AddRequest request) throws LdapException {
        return this.connection.add(request);
    }

    @Override
    public Result add(Entry entry) throws LdapException {
        return this.connection.add(entry);
    }

    @Override
    public Result add(String ... ldifLines) throws LdapException {
        return this.connection.add(ldifLines);
    }

    @Override
    public LdapPromise<Result> addAsync(AddRequest request) {
        return this.connection.addAsync(request);
    }

    @Override
    public LdapPromise<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.connection.addAsync(request, intermediateResponseHandler);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.connection.addConnectionEventListener(listener);
    }

    @Override
    public Result applyChange(ChangeRecord request) throws LdapException {
        return this.connection.applyChange(request);
    }

    @Override
    public LdapPromise<Result> applyChangeAsync(ChangeRecord request) {
        return this.connection.applyChangeAsync(request);
    }

    @Override
    public LdapPromise<Result> applyChangeAsync(ChangeRecord request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.connection.applyChangeAsync(request, intermediateResponseHandler);
    }

    @Override
    public BindResult bind(BindRequest request) throws LdapException {
        return this.connection.bind(request);
    }

    @Override
    public BindResult bind(String name, char[] password) throws LdapException {
        return this.connection.bind(name, password);
    }

    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request) {
        return this.connection.bindAsync(request);
    }

    @Override
    public LdapPromise<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.connection.bindAsync(request, intermediateResponseHandler);
    }

    @Override
    public void close() {
        this.connection.close();
    }

    @Override
    public void close(UnbindRequest request, String reason) {
        this.connection.close(request, reason);
    }

    @Override
    public CompareResult compare(CompareRequest request) throws LdapException {
        return this.connection.compare(request);
    }

    @Override
    public CompareResult compare(String name, String attributeDescription, String assertionValue) throws LdapException {
        return this.connection.compare(name, attributeDescription, assertionValue);
    }

    @Override
    public LdapPromise<CompareResult> compareAsync(CompareRequest request) {
        return this.connection.compareAsync(request);
    }

    @Override
    public LdapPromise<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.connection.compareAsync(request, intermediateResponseHandler);
    }

    @Override
    public Result delete(DeleteRequest request) throws LdapException {
        return this.connection.delete(request);
    }

    @Override
    public Result delete(String name) throws LdapException {
        return this.connection.delete(name);
    }

    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request) {
        return this.connection.deleteAsync(request);
    }

    @Override
    public LdapPromise<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.connection.deleteAsync(request, intermediateResponseHandler);
    }

    @Override
    public Result deleteSubtree(String name) throws LdapException {
        return this.connection.deleteSubtree(name);
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws LdapException {
        return this.connection.extendedRequest(request);
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws LdapException {
        return this.connection.extendedRequest(request, handler);
    }

    @Override
    public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws LdapException {
        return this.connection.extendedRequest(requestName, requestValue);
    }

    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request) {
        return this.connection.extendedRequestAsync(request);
    }

    @Override
    public <R extends ExtendedResult> LdapPromise<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.connection.extendedRequestAsync(request, intermediateResponseHandler);
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    @Override
    public boolean isValid() {
        return this.connection.isValid();
    }

    @Override
    public Result modify(ModifyRequest request) throws LdapException {
        return this.connection.modify(request);
    }

    @Override
    public Result modify(String ... ldifLines) throws LdapException {
        return this.connection.modify(ldifLines);
    }

    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request) {
        return this.connection.modifyAsync(request);
    }

    @Override
    public LdapPromise<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.connection.modifyAsync(request, intermediateResponseHandler);
    }

    @Override
    public Result modifyDn(ModifyDnRequest request) throws LdapException {
        return this.connection.modifyDn(request);
    }

    @Override
    public Result modifyDn(String name, String newRDN) throws LdapException {
        return this.connection.modifyDn(name, newRDN);
    }

    @Override
    public LdapPromise<Result> modifyDnAsync(ModifyDnRequest request) {
        return this.connection.modifyDnAsync(request);
    }

    @Override
    public LdapPromise<Result> modifyDnAsync(ModifyDnRequest request, IntermediateResponseHandler intermediateResponseHandler) {
        return this.modifyDnAsync(request, intermediateResponseHandler);
    }

    @Override
    public SearchResultEntry readEntry(Dn name, String ... attributeDescriptions) throws LdapException {
        return this.connection.readEntry(name, attributeDescriptions);
    }

    @Override
    public SearchResultEntry readEntry(String name, String ... attributeDescriptions) throws LdapException {
        return this.connection.readEntry(name, attributeDescriptions);
    }

    @Override
    public LdapPromise<SearchResultEntry> readEntryAsync(Dn name, Collection<String> attributeDescriptions) {
        return this.connection.readEntryAsync(name, attributeDescriptions);
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.connection.removeConnectionEventListener(listener);
    }

    @Override
    public ConnectionEntryReader search(SearchRequest request) {
        return this.connection.search(request);
    }

    @Override
    public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws LdapException {
        return this.connection.search(request, entries);
    }

    @Override
    public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries, Collection<? super SearchResultReference> references) throws LdapException {
        return this.connection.search(request, entries, references);
    }

    @Override
    public Result search(SearchRequest request, SearchResultHandler handler) throws LdapException {
        return this.connection.search(request, handler);
    }

    @Override
    public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
        return this.connection.search(baseObject, scope, filter, attributeDescriptions);
    }

    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, SearchResultHandler resultHandler) {
        return this.connection.searchAsync(request, resultHandler);
    }

    @Override
    public LdapPromise<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler entryHandler) {
        return this.connection.searchAsync(request, intermediateResponseHandler, entryHandler);
    }

    @Override
    public SearchResultEntry searchSingleEntry(SearchRequest request) throws LdapException {
        return this.connection.searchSingleEntry(request);
    }

    @Override
    public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws LdapException {
        return this.connection.searchSingleEntry(baseObject, scope, filter, attributeDescriptions);
    }

    @Override
    public LdapPromise<SearchResultEntry> searchSingleEntryAsync(SearchRequest request) {
        return this.connection.searchSingleEntryAsync(request);
    }

    public String toString() {
        return this.connection.toString();
    }
}

