/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.AbstractConnection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapPromise;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;

public abstract class AbstractAsynchronousConnection
extends AbstractConnection {
    protected AbstractAsynchronousConnection() {
    }

    @Override
    public Result add(AddRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.addAsync(request));
    }

    @Override
    public BindResult bind(BindRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.bindAsync(request));
    }

    @Override
    public CompareResult compare(CompareRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.compareAsync(request));
    }

    @Override
    public Result delete(DeleteRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.deleteAsync(request));
    }

    @Override
    public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws LdapException {
        return (R)((ExtendedResult)this.blockingGetOrThrow(this.extendedRequestAsync(request, handler)));
    }

    @Override
    public Result modify(ModifyRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.modifyAsync(request));
    }

    @Override
    public Result modifyDn(ModifyDnRequest request) throws LdapException {
        return this.blockingGetOrThrow(this.modifyDnAsync(request));
    }

    @Override
    public Result search(SearchRequest request, SearchResultHandler handler) throws LdapException {
        return this.blockingGetOrThrow(this.searchAsync(request, handler));
    }

    private <T extends Result> T blockingGetOrThrow(LdapPromise<T> promise) throws LdapException {
        try {
            return (T)((Result)promise.getOrThrow());
        }
        catch (InterruptedException e) {
            throw this.interrupted(e);
        }
    }

    private LdapException interrupted(InterruptedException e) {
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
    }
}

