/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.validators.ReferenceTypeValidator;
import org.forgerock.json.schema.validator.validators.SimpleValidator;

public abstract class Validator
implements SimpleValidator<Object> {
    protected boolean required = false;
    private JsonPointer pointer;

    public Validator(Map<String, Object> schema, List<String> jsonPointer) {
        Object o = schema.get("required");
        if (o instanceof Boolean) {
            this.required = (Boolean)o;
        } else if (o instanceof String) {
            this.required = Boolean.parseBoolean((String)o);
        }
        if (jsonPointer != null) {
            this.pointer = new JsonPointer(jsonPointer.toArray(new String[jsonPointer.size()]));
        }
    }

    protected final JsonPointer getPath(JsonPointer at, String property) {
        JsonPointer path;
        JsonPointer jsonPointer = path = null == at ? new JsonPointer() : at;
        if (null == property) {
            return path;
        }
        return path.child(property);
    }

    protected List<String> newList(List<String> list, String ... newElems) {
        ArrayList<String> results = new ArrayList<String>(list.size() + newElems.length);
        results.addAll(list);
        for (String elem : newElems) {
            if (elem == null) {
                throw new IllegalArgumentException();
            }
            results.add(elem);
        }
        return results;
    }

    public JsonPointer getJsonPointer() {
        return this.pointer;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void resolveSchemaReferences() {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        this.collectAllValidators(validators);
        ArrayList<ReferenceTypeValidator> references = new ArrayList<ReferenceTypeValidator>();
        HashMap<JsonPointer, Validator> jsonPointers = new HashMap<JsonPointer, Validator>();
        for (Validator validator : validators) {
            ReferenceTypeValidator val;
            if (validator.getJsonPointer() != null) {
                jsonPointers.put(validator.getJsonPointer(), validator);
            }
            if (!(validator instanceof ReferenceTypeValidator) || (val = (ReferenceTypeValidator)validator).getReference() == null) continue;
            references.add(val);
        }
        for (ReferenceTypeValidator v : references) {
            JsonPointer path;
            Validator referencedValidator;
            String ref = v.getReference();
            if (ref.startsWith("#")) {
                ref = ref.substring(1);
            }
            if ((referencedValidator = (Validator)jsonPointers.get(path = new JsonPointer(ref))) == null) {
                throw new SchemaException(new JsonValue(null, path), "Could not dereference JSON reference " + ref);
            }
            v.setReferencedValidator(referencedValidator);
        }
    }

    protected void collectAllValidators(Collection<Validator> results) {
        results.add(this);
    }

    protected static void collectAllValidators(Collection<Validator> results, Collection<? extends Validator> col) {
        if (col != null) {
            for (Validator validator : col) {
                validator.collectAllValidators(results);
            }
        }
    }

    protected static void collectAllValidators(Collection<Validator> results, Map<?, ? extends Validator> map) {
        if (map != null) {
            Validator.collectAllValidators(results, map.values());
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.getJsonPointer();
    }
}

