/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.List;
import java.util.Map;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.validators.Validator;

public class ReferenceTypeValidator
extends Validator {
    private final String reference;
    private Validator referenceValidator;

    public ReferenceTypeValidator(Map<String, Object> schema, String reference, List<String> jsonPointer) {
        super(schema, jsonPointer);
        this.reference = reference;
    }

    @Override
    public void validate(Object node, JsonPointer at, ErrorHandler handler) {
        if (this.referenceValidator == null) {
            throw new SchemaException(new JsonValue(null, this.getJsonPointer()), "Could not dereference JSON reference " + this.reference);
        }
        this.referenceValidator.validate(node, this.getPath(at, null), handler);
    }

    public String getReference() {
        return this.reference;
    }

    public void setReferencedValidator(Validator validator) {
        this.referenceValidator = validator;
    }
}

