/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.helpers;

import java.lang.reflect.Method;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.validators.SimpleValidator;

public class MinimumHelper
implements SimpleValidator<Number> {
    private final Number minimum;
    private int exclusiveMinimum = 0;

    public MinimumHelper(Number minimum, boolean exclusiveMinimum) {
        this.minimum = minimum;
        this.exclusiveMinimum = exclusiveMinimum ? -1 : 0;
    }

    @Override
    public void validate(Number node, JsonPointer at, ErrorHandler handler) throws SchemaException {
        if (this.minimum.getClass().isAssignableFrom(node.getClass())) {
            try {
                Method method = this.minimum.getClass().getMethod("compareTo", this.minimum.getClass());
                method.invoke((Object)this.minimum, node);
                if ((Integer)method.invoke((Object)this.minimum, node) > this.exclusiveMinimum) {
                    handler.error(new ValidationException("minimum violation", at));
                }
            }
            catch (Exception e) {
                handler.error(new ValidationException("Reflection exception at \"compareTo\" method invocation.", e, at));
            }
        } else if (this.minimum instanceof Float) {
            if (((Float)this.minimum).compareTo(Float.valueOf(node.floatValue())) > this.exclusiveMinimum) {
                handler.error(new ValidationException("minimum violation", at));
            }
        } else if (this.minimum instanceof Double) {
            if (((Double)this.minimum).compareTo(node.doubleValue()) > this.exclusiveMinimum) {
                handler.error(new ValidationException("minimum violation", at));
            }
        } else if (this.minimum instanceof Integer) {
            if (((Integer)this.minimum).compareTo(node.intValue()) > this.exclusiveMinimum) {
                handler.error(new ValidationException("minimum violation", at));
            }
        } else if (this.minimum instanceof Long && ((Long)this.minimum).compareTo(node.longValue()) > this.exclusiveMinimum) {
            handler.error(new ValidationException("minimum violation", at));
        }
    }
}

