/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import java.util.Arrays;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonPointer;
import org.forgerock.util.Reject;

public final class SortKey {
    private final JsonPointer field;
    private final boolean isAscendingOrder;

    public static SortKey ascendingOrder(JsonPointer field) {
        return new SortKey(field, true);
    }

    public static SortKey ascendingOrder(String field) {
        try {
            return SortKey.ascendingOrder(new JsonPointer(field));
        }
        catch (JsonException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static SortKey descendingOrder(JsonPointer field) {
        return new SortKey(field, false);
    }

    public static SortKey descendingOrder(String field) {
        try {
            return SortKey.descendingOrder(new JsonPointer(field));
        }
        catch (JsonException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static SortKey reverseOrder(SortKey key) {
        return new SortKey(key.field, !key.isAscendingOrder);
    }

    private SortKey(JsonPointer field, boolean isAscendingOrder) {
        this.field = Reject.checkNotNull(field, "SortKey field cannot be null");
        this.isAscendingOrder = isAscendingOrder;
    }

    public JsonPointer getField() {
        return this.field;
    }

    public boolean isAscendingOrder() {
        return this.isAscendingOrder;
    }

    public static SortKey valueOf(String s) {
        if (s.length() == 0) {
            throw new IllegalArgumentException("Empty sort key");
        }
        switch (s.charAt(0)) {
            case '-': {
                return SortKey.descendingOrder(s.substring(1));
            }
            case '+': {
                return SortKey.ascendingOrder(s.substring(1));
            }
        }
        return SortKey.ascendingOrder(s);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.isAscendingOrder ? (char)'+' : '-');
        builder.append(this.field);
        return builder.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof SortKey && ((SortKey)obj).isAscendingOrder() == this.isAscendingOrder() && ((SortKey)obj).getField().equals(this.getField());
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.isAscendingOrder, this.field});
    }
}

