/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk.store;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.forgerock.json.jose.exceptions.FailedToLoadJWKException;
import org.forgerock.json.jose.jwk.store.JwksStore;
import org.forgerock.util.SimpleHTTPClient;
import org.forgerock.util.time.Duration;

public class JwksStoreService {
    public static final Duration JWKS_STORE_DEFAULT_CACHE_TIMEOUT_MS = Duration.duration(1L, TimeUnit.HOURS);
    public static final Duration JWKS_STORE_DEFAULT_CACHE_MISS_CACHE_TIME_MS = Duration.duration(1L, TimeUnit.MINUTES);
    private final SimpleHTTPClient simpleHTTPClient;
    private final Map<String, JwksStore> jwksStoreByUID = new HashMap<String, JwksStore>();

    public JwksStoreService() {
        this(new SimpleHTTPClient());
    }

    public JwksStoreService(int readTimeout, int connTimeout) {
        this(new SimpleHTTPClient(readTimeout, connTimeout));
    }

    public JwksStoreService(SimpleHTTPClient simpleHTTPClient) {
        this.simpleHTTPClient = simpleHTTPClient;
    }

    public synchronized JwksStore getJwksStore(String uid) {
        return this.jwksStoreByUID.get(uid.toLowerCase());
    }

    public synchronized JwksStore configureJwksStore(String uid, Duration cacheTimeout, Duration cacheMissCacheTime, URL jwkUrl) throws FailedToLoadJWKException {
        JwksStore jwksStore = this.getJwksStore(uid = uid.toLowerCase());
        if (jwksStore != null) {
            jwksStore.setCacheTimeout(cacheTimeout);
            jwksStore.setCacheMissCacheTime(cacheMissCacheTime);
            jwksStore.setJwkUrl(jwkUrl);
            return jwksStore;
        }
        jwksStore = new JwksStore(cacheTimeout, cacheMissCacheTime, jwkUrl, this.simpleHTTPClient);
        this.jwksStoreByUID.put(uid, jwksStore);
        return jwksStore;
    }

    public synchronized void removeJwksStore(String uid) {
        this.jwksStoreByUID.remove(uid.toLowerCase());
    }
}

