/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import java.util.List;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.jwk.JWK;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jwt.Algorithm;
import org.forgerock.util.encode.Base64url;

public class OctJWK
extends JWK {
    private static final String JSON_KEY_K = "k";
    private final String key;

    public static Builder builder(String key) {
        return new Builder(key);
    }

    @Deprecated
    public OctJWK(KeyUse use, String alg, String kid, String key, String x5u, String x5t, List<String> x5c) {
        super(KeyType.OCT, use, alg, kid, x5u, x5t, x5c);
        if (key == null || key.isEmpty()) {
            throw new JsonException("key is a required field for an OctJWK");
        }
        this.key = key;
    }

    private OctJWK(Builder builder) {
        super(KeyType.OCT, builder.use, builder.keyOperations, builder.algorithm, builder.keyId, builder.x509url, builder.x509Thumbnail, builder.x509Chain);
        this.key = builder.key;
    }

    public String getKey() {
        return this.key;
    }

    public SecretKey toSecretKey() {
        Algorithm algorithm = this.getJwaAlgorithm();
        String keyAlg = null;
        if (algorithm instanceof JwsAlgorithm) {
            keyAlg = ((JwsAlgorithm)algorithm).getMdAlgorithm();
        } else if (algorithm != null) {
            keyAlg = algorithm.getAlgorithm();
        }
        if (keyAlg == null) {
            keyAlg = this.getUse() == KeyUse.ENC ? "AES" : "Hmac";
        }
        return new SecretKeySpec(Base64url.decode(this.key), keyAlg);
    }

    public static OctJWK parse(String json) {
        return OctJWK.parse(new JsonValue(OctJWK.toJsonValue(json)));
    }

    public static OctJWK parse(JsonValue json) {
        if (json == null) {
            throw new JsonException("Cant parse OctJWK. No json data.");
        }
        KeyType kty = KeyType.getKeyType(json.get("kty").asString());
        if (!kty.equals((Object)KeyType.OCT)) {
            throw new JsonException("Invalid key type. Not an Oct JWK");
        }
        Builder builder = OctJWK.builder(json.get(JSON_KEY_K).asString());
        OctJWK.loadJWKFromJson(builder, json);
        return builder.build();
    }

    @Override
    public String toJsonString() {
        return super.toString();
    }

    @Override
    public JsonValue toJsonValue() {
        JsonValue jsonValue = super.toJsonValue();
        jsonValue.put(JSON_KEY_K, (Object)this.key);
        return jsonValue;
    }

    public static final class Builder
    extends JWK.Builder<Builder> {
        private final String key;

        private Builder(String key) {
            super(KeyType.OCT);
            if (key == null || key.isEmpty()) {
                throw new IllegalArgumentException("key is a required field for an OctJWK");
            }
            this.key = key;
        }

        public OctJWK build() {
            return new OctJWK(this);
        }
    }
}

