/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.common;

import java.util.HashMap;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.exceptions.InvalidJwtException;
import org.forgerock.json.jose.exceptions.JwtReconstructionException;
import org.forgerock.json.jose.jwe.CompressionManager;
import org.forgerock.json.jose.jwe.EncryptedJwt;
import org.forgerock.json.jose.jwe.JweHeader;
import org.forgerock.json.jose.jwe.SignedThenEncryptedJwt;
import org.forgerock.json.jose.jws.EncryptedThenSignedJwt;
import org.forgerock.json.jose.jws.JwsHeader;
import org.forgerock.json.jose.jws.SignedEncryptedJwt;
import org.forgerock.json.jose.jws.SignedJwt;
import org.forgerock.json.jose.jwt.Jwt;
import org.forgerock.json.jose.jwt.JwtClaimsSet;
import org.forgerock.json.jose.jwt.JwtType;
import org.forgerock.json.jose.jwt.Payload;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.encode.Base64url;

public class JwtReconstruction {
    private static final String PAYLOAD_CONTENT_TYPE = "cty";
    private static final String JWT_TYPE = "typ";
    private static final String ENCRYPTION_METHOD = "enc";
    private static final String ALGORITHM = "alg";
    private static final int JWS_NUM_PARTS = 3;
    private static final int JWE_NUM_PARTS = 5;

    public <T extends Jwt> T reconstructJwt(String jwtString, Class<T> jwtClass) {
        Payload jwt;
        String[] jwtParts = jwtString.split("\\.", -1);
        if (jwtParts.length != 3 && jwtParts.length != 5) {
            throw new InvalidJwtException("not right number of dots, " + jwtParts.length);
        }
        JsonValue headerJson = new JsonValue(Utils.parseJson(Utils.base64urlDecode(jwtParts[0])));
        JwtType contentType = null;
        if (headerJson.isDefined(PAYLOAD_CONTENT_TYPE)) {
            contentType = JwtType.jwtType(headerJson.get(PAYLOAD_CONTENT_TYPE).asString());
        }
        JwtType jwtType = null;
        if (headerJson.isDefined(JWT_TYPE)) {
            jwtType = JwtType.jwtType(headerJson.get(JWT_TYPE).asString());
        }
        if (headerJson.isDefined(ENCRYPTION_METHOD)) {
            this.verifyNumberOfParts(jwtParts, 5);
            jwt = this.reconstructEncryptedJwt(jwtParts);
        } else if (JwtType.JWE == contentType || JwtType.JWT == contentType || JwtType.JWE == jwtType) {
            this.verifyNumberOfParts(jwtParts, 3);
            jwt = this.reconstructSignedEncryptedJwt(jwtParts);
        } else if (headerJson.isDefined(ALGORITHM)) {
            this.verifyNumberOfParts(jwtParts, 3);
            jwt = this.reconstructSignedJwt(jwtParts);
        } else {
            this.verifyNumberOfParts(jwtParts, 3);
            if (!jwtParts[2].isEmpty()) {
                throw new InvalidJwtException("Third part of Plaintext JWT not empty.");
            }
            jwt = this.reconstructSignedJwt(jwtParts);
        }
        return (T)((Jwt)jwtClass.cast(jwt));
    }

    private void verifyNumberOfParts(String[] jwtParts, int required) {
        if (jwtParts.length != required) {
            throw new JwtReconstructionException("Not the correct number of JWT parts. Expecting, " + required + ", actually, " + jwtParts.length);
        }
    }

    private SignedJwt reconstructSignedJwt(String[] jwtParts) {
        String encodedHeader = jwtParts[0];
        String encodedClaimsSet = jwtParts[1];
        String encodedSignature = jwtParts[2];
        String header = Utils.base64urlDecode(encodedHeader);
        byte[] signature = Base64url.decode(encodedSignature);
        JwsHeader jwsHeader = new JwsHeader(Utils.parseJson(header));
        byte[] payload = new CompressionManager().decompress(jwsHeader.getCompressionAlgorithm(), encodedClaimsSet);
        JwtClaimsSet claimsSet = new JwtClaimsSet(Utils.parseJson(new String(payload, Utils.CHARSET)));
        return new SignedJwt(jwsHeader, claimsSet, (encodedHeader + "." + encodedClaimsSet).getBytes(Utils.CHARSET), signature);
    }

    private EncryptedJwt reconstructEncryptedJwt(String[] jwtParts) {
        String encodedHeader = jwtParts[0];
        String encodedEncryptedKey = jwtParts[1];
        String encodedInitialisationVector = jwtParts[2];
        String encodedCiphertext = jwtParts[3];
        String encodedAuthenticationTag = jwtParts[4];
        String header = Utils.base64urlDecode(encodedHeader);
        byte[] encryptedContentEncryptionKey = Base64url.decode(encodedEncryptedKey);
        byte[] initialisationVector = Base64url.decode(encodedInitialisationVector);
        byte[] ciphertext = Base64url.decode(encodedCiphertext);
        byte[] authenticationTag = Base64url.decode(encodedAuthenticationTag);
        JweHeader jweHeader = new JweHeader(Utils.parseJson(header));
        if (jweHeader.getContentType() != null) {
            return new SignedThenEncryptedJwt(jweHeader, encodedHeader, encryptedContentEncryptionKey, initialisationVector, ciphertext, authenticationTag);
        }
        return new EncryptedJwt(jweHeader, encodedHeader, encryptedContentEncryptionKey, initialisationVector, ciphertext, authenticationTag);
    }

    private EncryptedThenSignedJwt reconstructSignedEncryptedJwt(String[] jwtParts) {
        String encodedHeader = jwtParts[0];
        String encodedPayload = jwtParts[1];
        String encodedSignature = jwtParts[2];
        String header = Utils.base64urlDecode(encodedHeader);
        String payloadString = Utils.base64urlDecode(encodedPayload);
        byte[] signature = Base64url.decode(encodedSignature);
        String[] encryptedJwtParts = payloadString.split("\\.", -1);
        this.verifyNumberOfParts(encryptedJwtParts, 5);
        EncryptedJwt encryptedJwt = this.reconstructEncryptedJwt(encryptedJwtParts);
        HashMap<String, Object> combinedHeader = new HashMap<String, Object>(encryptedJwt.getHeader().getParameters());
        combinedHeader.putAll(Utils.parseJson(header));
        JwsHeader jwsHeader = new JwsHeader(combinedHeader);
        return new SignedEncryptedJwt(jwsHeader, encryptedJwt, (encodedHeader + "." + encodedPayload).getBytes(Utils.CHARSET), signature);
    }
}

