/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import io.swagger.models.Swagger;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.Handler;
import org.forgerock.http.handler.DescribableHandler;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.ResponseException;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.routing.RouteMatchers;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.services.context.Context;
import org.forgerock.services.descriptor.Describable;
import org.forgerock.services.routing.AbstractRouter;
import org.forgerock.services.routing.IncomparableRouteMatchException;
import org.forgerock.services.routing.RouteMatcher;
import org.forgerock.util.Pair;
import org.forgerock.util.promise.NeverThrowsException;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Router
extends AbstractRouter<Router, Request, Handler, Swagger>
implements DescribableHandler {
    private static final Logger logger = LoggerFactory.getLogger(Router.class);
    private Handler selfApiHandler = new SelfApiHandler();

    public Router() {
    }

    public Router(Router router) {
        super(router);
    }

    @Override
    protected Router getThis() {
        return this;
    }

    @Override
    protected RouteMatcher<Request> uriMatcher(RoutingMode mode, String pattern) {
        return RouteMatchers.requestUriMatcher(mode, pattern);
    }

    @Override
    protected Pair<RouteMatcher<Request>, Handler> getSelfApiHandler() {
        return Pair.of(RouteMatchers.selfApiMatcher(), this.selfApiHandler);
    }

    @Override
    public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
        try {
            Pair bestMatch = this.getBestRoute(context, request);
            if (bestMatch != null) {
                return ((Handler)bestMatch.getSecond()).handle(bestMatch.getFirst(), request);
            }
            return Promises.newResultPromise(Responses.newNotFound());
        }
        catch (IncomparableRouteMatchException e) {
            if (logger.isTraceEnabled()) {
                logger.trace("Route for '{}' not found", (Object)RouteMatchers.getRemainingRequestUri(context, request));
            }
            return Promises.newResultPromise(new ResponseException(e.getMessage()).getResponse());
        }
    }

    private class SelfApiHandler
    implements DescribableHandler {
        private SelfApiHandler() {
        }

        @Override
        public Swagger api(ApiProducer<Swagger> producer) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Swagger handleApiRequest(Context context, Request request) {
            return (Swagger)Router.this.api;
        }

        @Override
        public void addDescriptorListener(Describable.Listener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removeDescriptorListener(Describable.Listener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Promise<Response, NeverThrowsException> handle(Context context, Request request) {
            throw new UnsupportedOperationException();
        }
    }
}

