/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.routing;

import org.forgerock.http.routing.DefaultVersionBehaviour;
import org.forgerock.http.routing.Version;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueFunctions;
import org.forgerock.services.context.AbstractContext;
import org.forgerock.services.context.Context;

public class ApiVersionRouterContext
extends AbstractContext {
    private static final String DEFAULT_VERSION_BEHAVIOUR = "defaultVersionBehaviour";
    private static final String WARNING_ENABLED = "warningEnabled";
    private Version protocolVersion;
    private Version resourceVersion;

    public ApiVersionRouterContext(Context parent, DefaultVersionBehaviour defaultVersionBehaviour, boolean warningEnabled) {
        this(parent);
        if (defaultVersionBehaviour != null) {
            this.data.put(DEFAULT_VERSION_BEHAVIOUR, (Object)defaultVersionBehaviour.toString());
        }
        this.data.put(WARNING_ENABLED, (Object)warningEnabled);
    }

    public ApiVersionRouterContext(JsonValue savedContext, ClassLoader classLoader) {
        super(savedContext, classLoader);
        if (this.data.isDefined("protocolVersion")) {
            this.protocolVersion = Version.version(this.data.get("protocolVersion").asString());
        }
        if (this.data.isDefined("resourceVersion")) {
            this.protocolVersion = Version.version(this.data.get("resourceVersion").asString());
        }
    }

    ApiVersionRouterContext(Context parent) {
        super(parent, "apiVersionRouter");
    }

    public DefaultVersionBehaviour getDefaultVersionBehaviour() {
        if (this.data.isDefined(DEFAULT_VERSION_BEHAVIOUR) && this.data.get(DEFAULT_VERSION_BEHAVIOUR).isNotNull()) {
            return this.data.get(DEFAULT_VERSION_BEHAVIOUR).as(JsonValueFunctions.enumConstant(DefaultVersionBehaviour.class));
        }
        return null;
    }

    public boolean isWarningEnabled() {
        return this.data.get(WARNING_ENABLED).defaultTo(true).asBoolean();
    }

    public void setProtocolVersion(Version protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.data.put("protocolVersion", (Object)protocolVersion.toString());
    }

    public Version getProtocolVersion() {
        return this.protocolVersion;
    }

    void setResourceVersion(Version resourceVersion) {
        this.resourceVersion = resourceVersion;
        this.data.put("resourceVersion", (Object)resourceVersion.toString());
    }

    public Version getResourceVersion() {
        return this.resourceVersion;
    }
}

