/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.http.header.GenericHeader;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.MalformedHeaderException;
import org.forgerock.http.protocol.Header;

public class Headers
implements Map<String, Object> {
    private final Map<String, Header> headers = new TreeMap<String, Header>(String.CASE_INSENSITIVE_ORDER);

    public Headers() {
    }

    Headers(Headers headers) {
        for (Map.Entry<String, Header> entry : headers.asMapOfHeaders().entrySet()) {
            this.add(entry.getKey(), entry.getValue().getValues());
        }
    }

    @Override
    public Header get(Object key) {
        return this.headers.get(key);
    }

    public String getFirst(String key) {
        Header header = this.headers.get(key);
        return header == null ? null : header.getFirstValue();
    }

    public String getFirst(Class<? extends Header> key) {
        Header header = this.headers.get(this.getHeaderName(key));
        return header == null ? null : header.getFirstValue();
    }

    public <H extends Header> H get(Class<H> headerType) throws MalformedHeaderException {
        Header header = this.get(this.getHeaderName(headerType));
        if (header instanceof GenericHeader) {
            throw new MalformedHeaderException("Header value(s) are not well formed");
        }
        return (H)((Header)headerType.cast(header));
    }

    private <H extends Header> String getHeaderName(Class<H> headerType) {
        String headerName = HeaderFactory.HEADER_NAMES.get(headerType);
        if (headerName == null) {
            throw new IllegalArgumentException("Unknown header type: " + headerType);
        }
        return headerName;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Header put(String key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        HeaderFactory<?> factory = HeaderFactory.FACTORIES.get(key);
        if (value instanceof Header) {
            return this.putHeader(key, (Header)value, factory);
        }
        if (factory != null) {
            return this.putUsingFactory(key, value, factory);
        }
        return this.putGenericHeader(key, value);
    }

    private Header putGenericHeader(String key, Object value) {
        if (value instanceof String) {
            return this.putGenericString(key, (String)value);
        }
        if (value instanceof List) {
            return this.putGenericList(key, (List)value);
        }
        if (value instanceof Collection) {
            return this.putGenericList(key, new ArrayList((Collection)value));
        }
        if (value.getClass().isArray()) {
            return this.putGenericList(key, Arrays.asList((Object[])value));
        }
        throw new IllegalArgumentException("Cannot put object for key '" + key + "': " + value);
    }

    private Header putHeader(String key, Header header, HeaderFactory<?> factory) {
        if (!this.hasAnyValue(header)) {
            return this.remove(key);
        }
        if (HeaderFactory.HEADER_NAMES.containsValue(key) && !HeaderFactory.HEADER_NAMES.get(header.getClass()).equals(key)) {
            if (header instanceof GenericHeader) {
                return this.putUsingFactory(key, header.getValues(), factory);
            }
            throw new IllegalArgumentException("Header object of incorrect type for header " + key);
        }
        return this.headers.put(key, header);
    }

    private boolean hasAnyValue(Header header) {
        boolean hasValue = false;
        for (String s : header.getValues()) {
            if (s == null) continue;
            hasValue = true;
            break;
        }
        return hasValue;
    }

    private Header putGenericList(String key, List<?> value) {
        if (value.isEmpty()) {
            return this.remove(key);
        }
        for (String string : value) {
            if (string instanceof String) continue;
            throw new IllegalArgumentException("Collections must be of strings");
        }
        return this.headers.put(key, new GenericHeader(key, value));
    }

    private Header putGenericString(String key, String value) {
        return this.headers.put(key, new GenericHeader(key, value));
    }

    private Header putUsingFactory(String key, Object value, HeaderFactory<?> factory) {
        Object parsed;
        try {
            parsed = factory.parse((Object)value);
        }
        catch (MalformedHeaderException e) {
            if (value instanceof Header) {
                value = ((Header)((Object)value)).getValues();
            }
            return this.putGenericHeader(key, value);
        }
        if (parsed == null) {
            return this.remove(key);
        }
        return this.headers.put(key, (Header)parsed);
    }

    @Override
    public Header remove(Object key) {
        return this.headers.remove(key);
    }

    public Header put(Header header) {
        return this.put(header.getName(), (Object)header);
    }

    public void add(Header header) {
        this.add(header.getName(), header);
    }

    /*
     * WARNING - void declaration
     */
    public void add(String key, Object value) {
        ArrayList<String> values;
        if (value == null) {
            return;
        }
        ArrayList<String> arrayList = values = this.containsKey(key) ? new ArrayList<String>(this.get(key).getValues()) : new ArrayList();
        if (value instanceof Header) {
            for (String string : ((Header)value).getValues()) {
                this.addNonNullStringValue(values, string);
            }
        } else if (value instanceof String) {
            values.add((String)value);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (String s : collection) {
                this.addNonNullStringValue(values, s);
            }
        } else if (value.getClass().isArray()) {
            String[] array;
            for (String s : array = (String[])value) {
                this.addNonNullStringValue(values, s);
            }
        } else {
            throw new IllegalArgumentException("Cannot add values for key '" + key + "': " + value);
        }
        if (values.isEmpty()) {
            return;
        }
        HeaderFactory<?> factory = HeaderFactory.FACTORIES.get(key);
        if (factory != null) {
            void var5_11;
            try {
                Object obj = factory.parse(values);
            }
            catch (MalformedHeaderException e) {
                GenericHeader genericHeader = new GenericHeader(key, values);
            }
            if (var5_11 == null) {
                return;
            }
            this.headers.put(key, (Header)var5_11);
        } else {
            this.headers.put(key, new GenericHeader(key, values));
        }
    }

    private void addNonNullStringValue(List<String> values, String s) {
        if (s != null) {
            values.add(s);
        }
    }

    public void addAll(Map<? extends String, ? extends Object> map) {
        for (Map.Entry<? extends String, ? extends Object> entry : map.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public int size() {
        return this.headers.size();
    }

    @Override
    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.headers.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.headers.containsValue(value);
    }

    @Override
    public void clear() {
        this.headers.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.headers.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.headers.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.headers.entrySet();
    }

    public Map<String, Header> asMapOfHeaders() {
        return this.headers;
    }

    public Map<String, List<String>> copyAsMultiMapOfStrings() {
        TreeMap<String, List<String>> result = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (Header header : this.headers.values()) {
            result.put(header.getName(), new ArrayList<String>(header.getValues()));
        }
        return result;
    }
}

