/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.protocol;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.forgerock.http.header.ContentEncodingHeader;
import org.forgerock.http.header.ContentTypeHeader;
import org.forgerock.http.io.BranchingInputStream;
import org.forgerock.http.io.IO;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.util.Json;
import org.forgerock.util.Utils;

public final class Entity
implements Closeable {
    public static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=UTF-8";
    private static final BranchingInputStream EMPTY_STREAM = IO.newBranchingInputStream(new byte[0]);
    private final Message message;
    private BranchingInputStream trunk;
    private BranchingInputStream head;
    private Object json;
    private String string;

    Entity(Message message) {
        this.message = message;
        this.setEmpty();
    }

    Entity(Message message, Entity entity) throws IOException {
        this.message = message;
        this.setRawContentInputStream(entity.trunk.copy());
    }

    public boolean isRawContentEmpty() {
        return this.isDecodedContentEmpty();
    }

    public boolean isDecodedContentEmpty() {
        this.push();
        try {
            boolean bl = this.head.read() == -1;
            this.pop();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.pop();
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
    }

    public void setEmpty() {
        this.setRawContentInputStream(EMPTY_STREAM);
    }

    @Override
    public void close() {
        this.setEmpty();
    }

    public void copyDecodedContentTo(OutputStream out) throws IOException {
        IO.stream(this.getDecodedInputStream(this.head), out);
        out.flush();
    }

    public void copyDecodedContentTo(Writer out) throws IOException {
        IO.stream(this.getBufferedReader(this.head, null), out);
        out.flush();
    }

    public void copyRawContentTo(OutputStream out) throws IOException {
        IO.stream(this.head, out);
        out.flush();
    }

    public byte[] getBytes() throws IOException {
        this.push();
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            this.copyDecodedContentTo(bytes);
            byte[] byArray = bytes.toByteArray();
            return byArray;
        }
        finally {
            this.pop();
        }
    }

    public Object getJson() throws IOException {
        if (this.json == null) {
            try (BufferedReader reader = this.newDecodedContentReader(StandardCharsets.UTF_8);){
                this.json = Json.readJson(reader);
            }
        }
        return this.json;
    }

    public InputStream getRawContentInputStream() {
        return this.head;
    }

    public String getString() throws IOException {
        if (this.string == null) {
            this.push();
            try {
                StringWriter writer = new StringWriter();
                this.copyDecodedContentTo(writer);
                this.string = writer.toString();
            }
            finally {
                this.pop();
            }
        }
        return this.string;
    }

    public InputStream newDecodedContentInputStream() throws IOException {
        BranchingInputStream headBranch = this.head.branch();
        try {
            return this.getDecodedInputStream(headBranch);
        }
        catch (IOException e) {
            Utils.closeSilently(headBranch);
            throw e;
        }
    }

    public BufferedReader newDecodedContentReader(Charset charset) throws IOException {
        BranchingInputStream headBranch = this.head.branch();
        try {
            return this.getBufferedReader(headBranch, charset);
        }
        catch (IOException e) {
            Utils.closeSilently(headBranch);
            throw e;
        }
    }

    public void pop() {
        Utils.closeSilently(this.head);
        this.head = this.head.parent();
    }

    public void push() throws IOException {
        this.head = this.head.branch();
    }

    public void setBytes(byte[] value) {
        if (value == null || value.length == 0) {
            this.message.getHeaders().put("Content-Length", (Object)0);
            this.setEmpty();
        } else {
            this.message.getHeaders().put("Content-Length", (Object)value.length);
            this.setRawContentInputStream(IO.newBranchingInputStream(value));
        }
    }

    public void setJson(Object value) {
        this.message.getHeaders().put("Content-Type", (Object)APPLICATION_JSON_CHARSET_UTF_8);
        try {
            this.setBytes(Json.writeJson(value));
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot produce JSON from " + value, e);
        }
        this.json = value;
    }

    public void setRawContentInputStream(BranchingInputStream is) {
        Utils.closeSilently(this.trunk);
        this.head = this.trunk = is != null ? is : EMPTY_STREAM;
        this.string = null;
        this.json = null;
    }

    public void setString(String value) {
        this.setBytes(value != null ? value.getBytes(this.cs(null)) : null);
        this.string = value;
    }

    public String toString() {
        try {
            return this.getString();
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }

    private Charset cs(Charset charset) {
        if (charset != null) {
            return charset;
        }
        Charset contentType = ContentTypeHeader.valueOf(this.message).getCharset();
        if (contentType != null) {
            return contentType;
        }
        return StandardCharsets.ISO_8859_1;
    }

    private BufferedReader getBufferedReader(InputStream is, Charset charset) throws IOException {
        return new BufferedReader(new InputStreamReader(this.getDecodedInputStream(is), this.cs(charset)));
    }

    private InputStream getDecodedInputStream(InputStream is) throws IOException {
        return ContentEncodingHeader.valueOf(this.message).decode(is);
    }
}

