/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.oauth2.resolver;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.forgerock.http.Handler;
import org.forgerock.http.oauth2.AccessTokenException;
import org.forgerock.http.oauth2.AccessTokenInfo;
import org.forgerock.http.oauth2.AccessTokenResolver;
import org.forgerock.http.protocol.Entity;
import org.forgerock.http.protocol.Form;
import org.forgerock.http.protocol.Headers;
import org.forgerock.http.protocol.Request;
import org.forgerock.http.protocol.Response;
import org.forgerock.http.protocol.Responses;
import org.forgerock.http.protocol.Status;
import org.forgerock.json.JsonValue;
import org.forgerock.json.JsonValueException;
import org.forgerock.services.context.Context;
import org.forgerock.util.CloseSilentlyFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.forgerock.util.promise.Promise;

public final class TokenIntrospectionAccessTokenResolver
implements AccessTokenResolver {
    private static final String RETURNED_ERROR = "Authorization server returned an error: '%s'";
    private static final String TOKEN_NOT_ACTIVE = "Access token returned by authorization server is not currently active";
    private static final String INVALID_JSON_TOKEN = "Invalid or malformed access token: '%s'";
    private static final String CANNOT_READ_RESPONSE = "Cannot read response content as JSON";
    private static final String FORM_TOKEN_FIELD = "token";
    private static final String FORM_TOKEN_TYPE_HINT_FIELD = "token_type_hint";
    private static final String FORM_TOKEN_TYPE_HINT_ACCESS_TOKEN = "access_token";
    private static final String RESPONSE_SCOPE_FIELD = "scope";
    private static final String RESPONSE_EXPIRE_TIME_FIELD = "exp";
    private static final String RESPONSE_ACTIVE_FIELD = "active";
    private final Handler client;
    private final URI introspectionEndpointUri;

    public TokenIntrospectionAccessTokenResolver(Handler client, URI introspectionEndpointUri) {
        this.client = Reject.checkNotNull(client);
        this.introspectionEndpointUri = Reject.checkNotNull(introspectionEndpointUri);
    }

    @Override
    public Promise<AccessTokenInfo, AccessTokenException> resolve(Context context, String token) {
        Request request = new Request().setUri(this.introspectionEndpointUri);
        Headers headers = request.getHeaders();
        headers.put("Accept", (Object)"application/json");
        Form form = new Form();
        form.add(FORM_TOKEN_FIELD, token);
        form.add(FORM_TOKEN_TYPE_HINT_FIELD, FORM_TOKEN_TYPE_HINT_ACCESS_TOKEN);
        form.toRequestEntity(request);
        return this.client.handle(context, request).thenAlways(Utils.closeSilentlyAsync(request)).then(this.buildAccessToken(token), Responses.noopExceptionFunction());
    }

    private Function<Response, AccessTokenInfo, AccessTokenException> buildAccessToken(String tokenSent) {
        return CloseSilentlyFunction.closeSilently(response -> {
            Status status = response.getStatus();
            if (!Status.OK.equals(status)) {
                throw new AccessTokenException(String.format(RETURNED_ERROR, status), response.getCause());
            }
            try (Entity entity = response.getEntity();){
                JsonValue jsonResponse = TokenIntrospectionAccessTokenResolver.asJson(entity);
                if (!jsonResponse.get(RESPONSE_ACTIVE_FIELD).required().asBoolean().booleanValue()) {
                    throw new AccessTokenException(TOKEN_NOT_ACTIVE);
                }
                AccessTokenInfo accessTokenInfo = TokenIntrospectionAccessTokenResolver.buildAccessTokenFromJson(jsonResponse, tokenSent);
                return accessTokenInfo;
            }
            catch (JsonValueException e) {
                throw new AccessTokenException(String.format(INVALID_JSON_TOKEN, e.getMessage()), e);
            }
        });
    }

    private static AccessTokenInfo buildAccessTokenFromJson(JsonValue response, String token) {
        JsonValue scopeValue = response.get(RESPONSE_SCOPE_FIELD);
        Set<String> tokenScopes = Collections.emptySet();
        if (!Utils.isNullOrEmpty(scopeValue.asString())) {
            tokenScopes = new HashSet<String>(Arrays.asList(scopeValue.asString().trim().split(" +")));
        }
        Long expiresAt = response.get(RESPONSE_EXPIRE_TIME_FIELD).defaultTo(Long.MAX_VALUE).asLong();
        return new AccessTokenInfo(response, token, tokenScopes, TimeUnit.SECONDS.toMillis(expiresAt));
    }

    private static JsonValue asJson(Entity entity) throws AccessTokenException {
        try {
            return new JsonValue(entity.getJson());
        }
        catch (IOException e) {
            throw new AccessTokenException(CANNOT_READ_RESPONSE, e);
        }
    }
}

