/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.forgerock.http.header.HeaderFactory;
import org.forgerock.http.header.HeaderUtil;
import org.forgerock.http.header.Warning;
import org.forgerock.http.protocol.Header;
import org.forgerock.http.protocol.Message;
import org.forgerock.util.Reject;

public final class WarningHeader
extends Header {
    public static final String NAME = "Warning";
    public static final int NOT_PRESENT = 100;
    public static final int RESPONSE_STALE = 110;
    public static final int REVALIDATION_FAILED = 111;
    public static final int DISCONNECTED_OPERATION = 112;
    public static final int HEURISTIC_EXPIRATION = 113;
    public static final int MISCELLANEOUS_WARNING = 199;
    public static final int TRANFORMATION_APPLIED = 214;
    public static final int MISCELLANEOUS_PERSISTENT_WARNING = 299;
    private final List<Warning> warnings;

    public static WarningHeader valueOf(Message message) {
        return new WarningHeader(WarningHeader.toWarnings(HeaderUtil.parseMultiValuedHeader(message, NAME)));
    }

    public static WarningHeader valueOf(String header) {
        return new WarningHeader(Warning.valueOf(header));
    }

    protected static List<Warning> toWarnings(List<String> headers) {
        ArrayList<Warning> warnings = new ArrayList<Warning>(headers.size());
        for (String entry : headers) {
            Warning warning = Warning.valueOf(entry);
            if (warning == null) continue;
            warnings.add(warning);
        }
        return warnings;
    }

    public static WarningHeader newWarning(String agentName, String fmt, Object ... args) {
        return new WarningHeader(new Warning(100, agentName, String.format(fmt, args)));
    }

    public WarningHeader(Warning warning) {
        ArrayList<Warning> warnings = new ArrayList<Warning>(1);
        warnings.add(Reject.checkNotNull(warning));
        this.warnings = Collections.unmodifiableList(warnings);
    }

    public WarningHeader(List<Warning> warnings) {
        this.warnings = Collections.unmodifiableList(new ArrayList(Reject.checkNotNull(warnings)));
    }

    @Override
    public String getName() {
        return NAME;
    }

    public WarningHeader add(int code, String agent, String text) {
        return this.add(code, agent, text, null);
    }

    public WarningHeader add(int code, String agent, String text, Date date) {
        return this.add(new Warning(code, agent, text, date));
    }

    public WarningHeader add(Warning warning) {
        Reject.ifNull(warning);
        ArrayList<Warning> list = new ArrayList<Warning>(this.warnings.size() + 1);
        list.addAll(this.warnings);
        list.add(warning);
        return new WarningHeader(list);
    }

    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @Override
    public List<String> getValues() {
        ArrayList<String> headerValues = new ArrayList<String>(this.warnings.size());
        for (Warning warning : this.warnings) {
            headerValues.add(warning.toString());
        }
        return Collections.unmodifiableList(headerValues);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WarningHeader that = (WarningHeader)o;
        return Objects.equals(this.warnings, that.warnings);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.warnings);
    }

    static class Factory
    extends HeaderFactory<WarningHeader> {
        Factory() {
        }

        @Override
        public WarningHeader parse(String value) {
            return WarningHeader.valueOf(value);
        }

        @Override
        public WarningHeader parse(List<String> values) {
            return new WarningHeader(WarningHeader.toWarnings(values));
        }
    }
}

