/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.models.Resource;
import org.forgerock.http.routing.Version;
import org.forgerock.util.Reject;

@JsonDeserialize(builder=Builder.class)
public final class VersionedPath {
    public static final Version UNVERSIONED = Version.version(0);
    private final Map<Version, Resource> paths;

    private VersionedPath(Builder builder) {
        this.paths = builder.paths;
        if (this.paths.isEmpty()) {
            throw new ApiValidationException("Must have at least one versioned resource");
        }
        if (this.paths.size() > 1) {
            for (Version version : this.paths.keySet()) {
                if (!UNVERSIONED.equals(version)) continue;
                throw new ApiValidationException("Version 0.0 (unversioned) must be the only version when used");
            }
        }
    }

    @JsonValue
    protected Map<Version, Resource> getPaths() {
        return this.paths;
    }

    @JsonIgnore
    public Resource get(Version version) {
        return this.paths.get(version);
    }

    @JsonIgnore
    public Set<Version> getVersions() {
        return this.paths.keySet();
    }

    public static Builder versionedPath() {
        return new Builder();
    }

    void addVersion(Version v, Resource resource) {
        if (this.paths.containsKey(v)) {
            throw new IllegalArgumentException("Trying to redefine version: " + v);
        }
        this.paths.put(v, Reject.checkNotNull(resource));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedPath that = (VersionedPath)o;
        return Objects.equals(this.paths, that.paths);
    }

    public int hashCode() {
        return Objects.hash(this.paths);
    }

    public static final class Builder {
        private final Map<Version, Resource> paths = new HashMap<Version, Resource>();

        private Builder() {
        }

        public Builder put(Version version, Resource resource) {
            if (this.paths.containsKey(version)) {
                throw new IllegalStateException("version not unique");
            }
            this.paths.put(Reject.checkNotNull(version), Reject.checkNotNull(resource));
            return this;
        }

        @JsonAnySetter
        public Builder put(String version, Resource resource) {
            return this.put(Version.version(version), resource);
        }

        public VersionedPath build() {
            return new VersionedPath(this);
        }
    }
}

