/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import java.util.Map;
import org.forgerock.json.JsonValue;
import org.forgerock.util.Function;
import org.forgerock.util.i18n.LocalizableString;
import org.forgerock.util.promise.NeverThrowsException;

public class TranslateJsonSchema
implements Function<JsonValue, JsonValue, NeverThrowsException> {
    private final ClassLoader loader;

    public TranslateJsonSchema(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public JsonValue apply(JsonValue value) {
        JsonValue returnValue = value;
        if (value.isCollection()) {
            JsonValue transformedValue = JsonValue.json(JsonValue.array(new Object[0]));
            for (JsonValue item : value) {
                transformedValue.add(item.as(this).getObject());
            }
            returnValue = transformedValue;
        } else if (value.isMap()) {
            JsonValue transformedValue = JsonValue.json(JsonValue.object(new Map.Entry[0]));
            for (String key : value.keys()) {
                transformedValue.put(key, value.get(key).as(this).getObject());
            }
            returnValue = transformedValue;
        } else if (value.isString() && value.asString().startsWith("i18n:")) {
            returnValue = JsonValue.json(new LocalizableString(value.asString(), this.loader));
        }
        return returnValue;
    }
}

