/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.enums.CountPolicy;
import org.forgerock.api.enums.PagingMode;
import org.forgerock.api.enums.QueryType;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Operation;
import org.forgerock.api.models.Resource;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.guava.common.base.Strings;

@JsonDeserialize(builder=Builder.class)
public final class Query
extends Operation
implements Comparable<Query> {
    private final QueryType type;
    private final PagingMode[] pagingModes;
    private final CountPolicy[] countPolicies;
    private final String queryId;
    private final String[] queryableFields;
    private final String[] supportedSortKeys;

    private Query(Builder builder) {
        super(builder);
        this.type = builder.type;
        this.pagingModes = builder.pagingModes;
        this.countPolicies = builder.countPolicies;
        this.queryId = builder.queryId;
        this.queryableFields = builder.queryableFields;
        this.supportedSortKeys = builder.supportedSortKeys;
        if (this.type == null) {
            throw new ApiValidationException("type is required");
        }
        if (this.type == QueryType.ID && ValidationUtil.isEmpty(this.queryId)) {
            throw new ApiValidationException("queryId required for type = ID");
        }
    }

    public QueryType getType() {
        return this.type;
    }

    public PagingMode[] getPagingModes() {
        return this.pagingModes;
    }

    public CountPolicy[] getCountPolicies() {
        return this.countPolicies;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String[] getQueryableFields() {
        return this.queryableFields;
    }

    public String[] getSupportedSortKeys() {
        return this.supportedSortKeys;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Query query = (Query)o;
        return this.type == query.type && Arrays.equals((Object[])this.pagingModes, (Object[])query.pagingModes) && Arrays.equals((Object[])this.countPolicies, (Object[])query.countPolicies) && Objects.equals(this.queryId, query.queryId) && Arrays.equals(this.queryableFields, query.queryableFields) && Arrays.equals(this.supportedSortKeys, query.supportedSortKeys);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.type, this.pagingModes, this.countPolicies, this.queryId, this.queryableFields, this.supportedSortKeys});
    }

    public static Builder query() {
        return new Builder();
    }

    @Override
    protected void allocateToResource(Resource.Builder resourceBuilder) {
        resourceBuilder.query(this);
    }

    public static Query fromAnnotation(org.forgerock.api.annotations.Query query, Method annotated, ApiDescription descriptor, Class<?> relativeType) {
        String queryId = query.id();
        if (query.type() == QueryType.ID && Strings.isNullOrEmpty(queryId)) {
            if (annotated == null) {
                throw new IllegalArgumentException("Query is missing ID: " + query);
            }
            queryId = annotated.getName();
        }
        return ((Builder)Query.query().detailsFromAnnotation(query.operationDescription(), descriptor, relativeType)).type(query.type()).pagingModes(query.pagingModes()).countPolicies(query.countPolicies()).queryId(queryId).queryableFields(query.queryableFields()).supportedSortKeys(query.sortKeys()).build();
    }

    @Override
    public int compareTo(Query query) {
        switch (query.getType()) {
            case EXPRESSION: {
                if (this.getType() == QueryType.EXPRESSION) {
                    return 0;
                }
                return 1;
            }
            case FILTER: {
                if (this.getType() == QueryType.FILTER) {
                    return 0;
                }
                if (this.getType() == QueryType.EXPRESSION) {
                    return -1;
                }
                return 1;
            }
            case ID: {
                if (this.getType() == QueryType.ID) {
                    return this.queryId.compareTo(query.getQueryId());
                }
                return -1;
            }
        }
        throw new IllegalStateException("Unsupported QueryType: " + (Object)((Object)query.getType()));
    }

    public static final class Builder
    extends Operation.Builder<Builder> {
        private QueryType type;
        private PagingMode[] pagingModes;
        private CountPolicy[] countPolicies;
        private String queryId;
        private String[] queryableFields;
        private String[] supportedSortKeys;

        @Override
        protected Builder self() {
            return this;
        }

        @JsonProperty(value="type")
        public Builder type(QueryType type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="pagingModes")
        public Builder pagingModes(PagingMode ... pagingMode) {
            this.pagingModes = pagingMode;
            return this;
        }

        @JsonProperty(value="countPolicies")
        public Builder countPolicies(CountPolicy ... countPolicy) {
            this.countPolicies = countPolicy;
            return this;
        }

        @JsonProperty(value="queryId")
        public Builder queryId(String queryId) {
            this.queryId = queryId;
            return this;
        }

        @JsonProperty(value="queryableFields")
        public Builder queryableFields(String ... queryableFields) {
            this.queryableFields = queryableFields;
            return this;
        }

        @JsonProperty(value="supportedSortKeys")
        public Builder supportedSortKeys(String ... supportedSortKeys) {
            this.supportedSortKeys = supportedSortKeys;
            return this;
        }

        public Query build() {
            return new Query(this);
        }
    }
}

