/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.models;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Comparator;
import java.util.Objects;
import org.forgerock.api.ApiValidationException;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.Reference;
import org.forgerock.api.models.Schema;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.guava.common.base.Strings;
import org.forgerock.util.i18n.LocalizableString;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
public final class ApiError {
    public static final ErrorComparator ERROR_COMPARATOR = new ErrorComparator();
    private final Integer code;
    private final LocalizableString description;
    private final Schema schema;
    @JsonProperty(value="$ref")
    private final Reference reference;

    private ApiError(Builder builder) {
        this.code = builder.code;
        this.description = builder.description;
        this.schema = builder.schema;
        this.reference = builder.reference;
        if (this.reference == null && (this.code == null || this.description == null || ValidationUtil.isEmpty(this.description.toString()))) {
            throw new ApiValidationException("code and description are required");
        }
        if (this.reference != null && (this.code != null || this.description != null || this.schema != null)) {
            throw new ApiValidationException("Cannot set code, description or schema when using a reference");
        }
    }

    public Integer getCode() {
        return this.code;
    }

    public LocalizableString getDescription() {
        return this.description;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Reference getReference() {
        return this.reference;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiError apiError = (ApiError)o;
        return Objects.equals(this.code, apiError.code) && Objects.equals(this.description, apiError.description) && Objects.equals(this.schema, apiError.schema) && Objects.equals(this.reference, apiError.reference);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.description, this.schema, this.reference);
    }

    public static Builder apiError() {
        return new Builder();
    }

    public static ApiError fromAnnotation(org.forgerock.api.annotations.ApiError apiError, ApiDescription descriptor, Class<?> relativeType) {
        ApiError apiErrorDefinition = ApiError.apiError().description(new LocalizableString(apiError.description(), relativeType)).code(apiError.code()).schema(Schema.fromAnnotation(apiError.detailSchema(), descriptor, relativeType)).build();
        if (!Strings.isNullOrEmpty(apiError.id())) {
            descriptor.addError(apiError.id(), apiErrorDefinition);
            return ApiError.apiError().reference(Reference.reference().value("#/errors/" + apiError.id()).build()).build();
        }
        return apiErrorDefinition;
    }

    private static class ErrorComparator
    implements Comparator<ApiError> {
        private ErrorComparator() {
        }

        @Override
        public int compare(ApiError o1, ApiError o2) {
            if (o1.getReference() != null) {
                return o2.getReference() != null ? o1.getReference().getValue().compareTo(o2.getReference().getValue()) : 1;
            }
            if (o2.getReference() != null) {
                return -1;
            }
            int codeCompare = o1.code.compareTo(o2.code);
            if (codeCompare == 0) {
                return o1.description.toString().compareTo(o2.description.toString());
            }
            return codeCompare;
        }
    }

    public static final class Builder {
        private Integer code;
        private LocalizableString description;
        private Schema schema;
        private Reference reference;

        private Builder() {
        }

        @JsonProperty(value="code")
        public Builder code(Integer code) {
            this.code = code;
            return this;
        }

        public Builder description(LocalizableString description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="description")
        public Builder description(String description) {
            this.description = new LocalizableString(description);
            return this;
        }

        @JsonProperty(value="schema")
        public Builder schema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @JsonProperty(value="$ref")
        public Builder reference(Reference reference) {
            this.reference = reference;
            return this;
        }

        public ApiError build() {
            return new ApiError(this);
        }
    }
}

