/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.glassfish.jersey.client;

import com.inwebo.repackaged.javax.ws.rs.ProcessingException;
import com.inwebo.repackaged.javax.ws.rs.client.ClientRequestFilter;
import com.inwebo.repackaged.javax.ws.rs.client.ClientResponseFilter;
import com.inwebo.repackaged.javax.ws.rs.client.ResponseProcessingException;
import com.inwebo.repackaged.javax.ws.rs.core.Response;
import com.inwebo.repackaged.org.glassfish.hk2.api.ServiceLocator;
import com.inwebo.repackaged.org.glassfish.jersey.client.AbortException;
import com.inwebo.repackaged.org.glassfish.jersey.client.ClientRequest;
import com.inwebo.repackaged.org.glassfish.jersey.client.ClientResponse;
import com.inwebo.repackaged.org.glassfish.jersey.client.InboundJaxrsResponse;
import com.inwebo.repackaged.org.glassfish.jersey.internal.inject.Providers;
import com.inwebo.repackaged.org.glassfish.jersey.model.internal.RankedComparator;
import com.inwebo.repackaged.org.glassfish.jersey.process.internal.AbstractChainableStage;
import com.inwebo.repackaged.org.glassfish.jersey.process.internal.ChainableStage;
import com.inwebo.repackaged.org.glassfish.jersey.process.internal.Stage;
import java.io.IOException;

class ClientFilteringStages {
    private ClientFilteringStages() {
    }

    static ChainableStage<ClientRequest> createRequestFilteringStage(ServiceLocator locator) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.ASCENDING);
        Iterable<ClientRequestFilter> requestFilters = Providers.getAllProviders(locator, ClientRequestFilter.class, comparator);
        return requestFilters.iterator().hasNext() ? new RequestFilteringStage(requestFilters) : null;
    }

    static ChainableStage<ClientResponse> createResponseFilteringStage(ServiceLocator locator) {
        RankedComparator comparator = new RankedComparator(RankedComparator.Order.DESCENDING);
        Iterable<ClientResponseFilter> responseFilters = Providers.getAllProviders(locator, ClientResponseFilter.class, comparator);
        return responseFilters.iterator().hasNext() ? new ResponseFilterStage(responseFilters) : null;
    }

    private static class ResponseFilterStage
    extends AbstractChainableStage<ClientResponse> {
        private final Iterable<ClientResponseFilter> filters;

        private ResponseFilterStage(Iterable<ClientResponseFilter> filters) {
            this.filters = filters;
        }

        @Override
        public Stage.Continuation<ClientResponse> apply(ClientResponse responseContext) {
            try {
                for (ClientResponseFilter filter : this.filters) {
                    filter.filter(responseContext.getRequestContext(), responseContext);
                }
            }
            catch (IOException ex) {
                InboundJaxrsResponse response = new InboundJaxrsResponse(responseContext, null);
                throw new ResponseProcessingException((Response)response, (Throwable)ex);
            }
            return Stage.Continuation.of(responseContext, this.getDefaultNext());
        }
    }

    private static final class RequestFilteringStage
    extends AbstractChainableStage<ClientRequest> {
        private final Iterable<ClientRequestFilter> requestFilters;

        private RequestFilteringStage(Iterable<ClientRequestFilter> requestFilters) {
            this.requestFilters = requestFilters;
        }

        @Override
        public Stage.Continuation<ClientRequest> apply(ClientRequest requestContext) {
            for (ClientRequestFilter filter : this.requestFilters) {
                try {
                    filter.filter(requestContext);
                    Response abortResponse = requestContext.getAbortResponse();
                    if (abortResponse == null) continue;
                    throw new AbortException(new ClientResponse(requestContext, abortResponse));
                }
                catch (IOException ex) {
                    throw new ProcessingException(ex);
                }
            }
            return Stage.Continuation.of(requestContext, this.getDefaultNext());
        }
    }
}

