/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.com.google.common.collect;

import com.inwebo.repackaged.com.google.common.base.Function;
import com.inwebo.repackaged.com.google.common.base.Objects;
import com.inwebo.repackaged.com.google.common.collect.Table;
import com.inwebo.repackaged.javax.annotation.Nullable;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;

public final class Tables {
    private static final Function<? extends Map<?, ?>, ? extends Map<?, ?>> UNMODIFIABLE_WRAPPER = new Function<Map<Object, Object>, Map<Object, Object>>(){

        @Override
        public Map<Object, Object> apply(Map<Object, Object> input) {
            return Collections.unmodifiableMap(input);
        }
    };

    public static <R, C, V> Table.Cell<R, C, V> immutableCell(@Nullable R rowKey, @Nullable C columnKey, @Nullable V value) {
        return new ImmutableCell<R, C, V>(rowKey, columnKey, value);
    }

    static boolean equalsImpl(Table<?, ?, ?> table, @Nullable Object obj) {
        if (obj == table) {
            return true;
        }
        if (obj instanceof Table) {
            Table that = (Table)obj;
            return table.cellSet().equals(that.cellSet());
        }
        return false;
    }

    static abstract class AbstractCell<R, C, V>
    implements Table.Cell<R, C, V> {
        AbstractCell() {
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Table.Cell) {
                Table.Cell other = (Table.Cell)obj;
                return Objects.equal(this.getRowKey(), other.getRowKey()) && Objects.equal(this.getColumnKey(), other.getColumnKey()) && Objects.equal(this.getValue(), other.getValue());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode(this.getRowKey(), this.getColumnKey(), this.getValue());
        }

        public String toString() {
            String string = String.valueOf(String.valueOf(this.getRowKey()));
            String string2 = String.valueOf(String.valueOf(this.getColumnKey()));
            String string3 = String.valueOf(String.valueOf(this.getValue()));
            return new StringBuilder(4 + string.length() + string2.length() + string3.length()).append("(").append(string).append(",").append(string2).append(")=").append(string3).toString();
        }
    }

    static final class ImmutableCell<R, C, V>
    extends AbstractCell<R, C, V>
    implements Serializable {
        private final R rowKey;
        private final C columnKey;
        private final V value;

        ImmutableCell(@Nullable R rowKey, @Nullable C columnKey, @Nullable V value) {
            this.rowKey = rowKey;
            this.columnKey = columnKey;
            this.value = value;
        }

        @Override
        public R getRowKey() {
            return this.rowKey;
        }

        @Override
        public C getColumnKey() {
            return this.columnKey;
        }

        @Override
        public V getValue() {
            return this.value;
        }
    }
}

