/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.client;

import com.inwebo.InWeboProxyLdap;
import java.util.Arrays;
import java.util.List;
import java.util.stream.StreamSupport;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldif.ConnectionEntryReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupLookupUtils {
    private static final Logger logger = LoggerFactory.getLogger(InWeboProxyLdap.class.getName());

    private static boolean checkUserMemberShipByGroup(Connection connection, String userDn, String groupDn, String memberAttribute, String userObjectClass, String groupObjectClass) throws Exception {
        if (GroupLookupUtils.checkUserMemberShipByGroup(connection, SearchScope.BASE_OBJECT, userDn, groupDn, memberAttribute, userObjectClass, groupObjectClass)) {
            return true;
        }
        return GroupLookupUtils.checkUserMemberShipByGroup(connection, SearchScope.SINGLE_LEVEL, userDn, groupDn, memberAttribute, userObjectClass, groupObjectClass);
    }

    private static boolean checkUserMemberShipByGroup(Connection connection, SearchScope scope, String userDn, String groupDn, String memberAttribute, String userObjectClass, String groupObjectClass) throws Exception {
        ByteString bsPersonObjectClass = ByteString.valueOfUtf8(userObjectClass);
        String filter = String.format("(|(objectClass=%s)(objectClass=%s))", groupObjectClass, userObjectClass);
        ByteString cookie = ByteString.empty();
        do {
            SearchRequest request = Requests.newSearchRequest(groupDn, scope, filter, "objectClass", memberAttribute);
            request.addControl(SimplePagedResultsControl.newControl(true, 50, cookie));
            try (ConnectionEntryReader reader = connection.search(request);){
                while (reader.hasNext()) {
                    if (reader.isEntry()) {
                        SearchResultEntry entry = reader.readEntry();
                        List<ByteString> objectClass = Arrays.asList(entry.getAttribute("objectClass").toArray());
                        if (objectClass.contains(bsPersonObjectClass)) {
                            if (!entry.getName().equals(Dn.valueOf(userDn))) continue;
                            boolean bl = true;
                            return bl;
                        }
                        if (StreamSupport.stream(entry.getAllAttributes(memberAttribute).spliterator(), false).filter(att -> att.stream().filter(a -> {
                            try {
                                if (Dn.valueOf(userDn).equals(Dn.valueOf(a.toString()))) {
                                    return true;
                                }
                                if (GroupLookupUtils.isGroup(connection, a.toString(), groupObjectClass)) {
                                    return GroupLookupUtils.checkUserMemberShipByGroup(connection, userDn, a.toString(), memberAttribute, userObjectClass, groupObjectClass);
                                }
                                return false;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return false;
                            }
                        }).findAny().isPresent()).findAny().isPresent()) {
                            boolean bl = true;
                            return bl;
                        }
                        if (!SearchScope.SINGLE_LEVEL.equals(scope) || !GroupLookupUtils.checkUserMemberShipByGroup(connection, userDn, entry.getName().toString(), memberAttribute, userObjectClass, groupObjectClass)) continue;
                        boolean bl = true;
                        return bl;
                    }
                    SearchResultReference ref = reader.readReference();
                    logger.info(groupDn + " : reference - " + ref.getUris());
                }
                cookie = reader.readResult().getControl(SimplePagedResultsControl.DECODER, new DecodeOptions()).getCookie();
            }
        } while (cookie.length() != 0);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isGroup(Connection connection, String entryDN, String groupObjectClass) throws LdapException {
        if (entryDN.startsWith("uid=")) {
            return false;
        }
        String filter = String.format("(objectClass=%s)", groupObjectClass);
        SearchRequest r = Requests.newSearchRequest(entryDN, SearchScope.BASE_OBJECT, filter, "");
        try (ConnectionEntryReader reader = connection.search(r);){
            if (reader.hasNext()) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (EntryNotFoundException e) {
            return false;
        }
    }

    public static boolean checkUserMemberShip(Connection connection, String userDn, String groupDn, String memberOfAttribute, String memberAttribute, String userObjectClass, String groupObjectClass) throws Exception {
        if (Dn.valueOf(userDn).isSubordinateOrEqualTo(groupDn)) {
            return true;
        }
        if (memberOfAttribute != null) {
            String filter = String.format("(&(objectClass=%s)(%s=%s))", userObjectClass, memberOfAttribute, groupDn);
            try (ConnectionEntryReader reader = connection.search(userDn, SearchScope.BASE_OBJECT, filter, memberOfAttribute);){
                if (reader.hasNext()) {
                    boolean bl = true;
                    return bl;
                }
            }
            filter = String.format("(objectClass=%s)", userObjectClass);
            SearchRequest r = Requests.newSearchRequest(userDn, SearchScope.BASE_OBJECT, filter, memberOfAttribute);
            try (ConnectionEntryReader reader = connection.search(r);){
                if (reader.hasNext()) {
                    if (reader.isEntry()) {
                        if (StreamSupport.stream(reader.readEntry().getAllAttributes(memberOfAttribute).spliterator(), false).filter(att -> att.stream().filter(a -> {
                            try {
                                return GroupLookupUtils.checkGroupMemberShip(connection, a.toString(), groupDn, memberOfAttribute, groupObjectClass);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                return false;
                            }
                        }).findAny().isPresent()).findAny().isPresent()) {
                            boolean bl = true;
                            return bl;
                        }
                    } else {
                        SearchResultReference ref = reader.readReference();
                        logger.info(userDn + " : reference - " + ref.getUris());
                    }
                }
            }
            if (GroupLookupUtils.checkGroupMemberShip(connection, Dn.valueOf(userDn).parent().toString(), groupDn, memberOfAttribute, groupObjectClass)) {
                return true;
            }
        } else if (memberAttribute != null) {
            if (GroupLookupUtils.checkUserMemberShipByGroup(connection, userDn, groupDn, memberAttribute, userObjectClass, groupObjectClass)) {
                return true;
            }
        } else {
            throw new Exception("memberOfAttribute or memberAttribute must be specified");
        }
        return false;
    }

    private static boolean checkGroupMemberShip(Connection connection, String baseGroupDn, String groupDn, String memberOfAttribute, String groupObjectClass) throws Exception {
        if (Dn.valueOf(baseGroupDn).isSubordinateOrEqualTo(groupDn)) {
            return true;
        }
        ByteString cookie = ByteString.empty();
        SearchRequest request = null;
        if (memberOfAttribute != null) {
            do {
                String filter = String.format("(objectClass=%s)", groupObjectClass);
                request = Requests.newSearchRequest(baseGroupDn, SearchScope.BASE_OBJECT, filter, memberOfAttribute);
                request.addControl(SimplePagedResultsControl.newControl(true, 5, cookie));
                try (ConnectionEntryReader reader = connection.search(request);){
                    while (reader.hasNext()) {
                        if (reader.isEntry()) {
                            SearchResultEntry entry = reader.readEntry();
                            if (StreamSupport.stream(entry.getAllAttributes(memberOfAttribute).spliterator(), false).filter(att -> att.stream().filter(a -> {
                                try {
                                    return GroupLookupUtils.checkGroupMemberShip(connection, a.toString(), groupDn, memberOfAttribute, groupObjectClass);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    return false;
                                }
                            }).findAny().isPresent()).findAny().isPresent()) {
                                boolean bl = true;
                                return bl;
                            }
                            if (!GroupLookupUtils.checkGroupMemberShip(connection, entry.getName().parent().toString(), groupDn, memberOfAttribute, groupObjectClass)) continue;
                            boolean bl = true;
                            return bl;
                        }
                        SearchResultReference ref = reader.readReference();
                        logger.info(baseGroupDn + " : reference - " + ref.getUris());
                    }
                    cookie = reader.readResult().getControl(SimplePagedResultsControl.DECODER, new DecodeOptions()).getCookie();
                }
            } while (cookie.length() != 0);
        }
        return false;
    }
}

