/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.extensions;

import com.forgerock.opendj.ldap.extensions.GetConnectionIdExtendedResult;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.io.Asn1;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.messages.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.messages.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedRequest;
import org.forgerock.opendj.ldap.messages.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.ExtendedResultDecoder;

public final class GetConnectionIdExtendedRequest
extends AbstractExtendedRequest<GetConnectionIdExtendedRequest, GetConnectionIdExtendedResult> {
    public static final String OID = "1.3.6.1.4.1.26027.1.6.2";
    private static final GetConnectionIdExtendedRequest INSTANCE = new GetConnectionIdExtendedRequest();
    public static final RequestDecoder REQUEST_DECODER = new RequestDecoder();
    private static final ResultDecoder RESULT_DECODER = new ResultDecoder();

    public static GetConnectionIdExtendedRequest newRequest() {
        return INSTANCE;
    }

    private GetConnectionIdExtendedRequest() {
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ExtendedResultDecoder<GetConnectionIdExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("GetConnectionIDExtendedRequest(requestName=");
        builder.append(this.getOid());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<GetConnectionIdExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public GetConnectionIdExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, CharSequence diagnosticMessage) {
            if (!resultCode.isExceptional()) {
                throw new IllegalArgumentException("No response name and value for result code " + resultCode.intValue());
            }
            return (GetConnectionIdExtendedResult)((GetConnectionIdExtendedResult)GetConnectionIdExtendedResult.newResult(resultCode).setMatchedDn(matchedDN)).setDiagnosticMessage(diagnosticMessage);
        }

        @Override
        public GetConnectionIdExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            if (result instanceof GetConnectionIdExtendedResult) {
                return (GetConnectionIdExtendedResult)result;
            }
            ResultCode resultCode = result.getResultCode();
            GetConnectionIdExtendedResult newResult = (GetConnectionIdExtendedResult)((GetConnectionIdExtendedResult)GetConnectionIdExtendedResult.newResult(resultCode).setMatchedDn(result.getMatchedDn())).setDiagnosticMessage(result.getDiagnosticMessage());
            ByteString responseValue = result.getValue();
            if (!resultCode.isExceptional() && responseValue == null) {
                throw DecodeException.error(LocalizableMessage.raw("Empty response value", new Object[0]));
            }
            if (responseValue != null) {
                try {
                    Asn1Reader reader = Asn1.getReader(responseValue);
                    newResult.setConnectionId((int)reader.readInteger());
                }
                catch (IOException e) {
                    throw DecodeException.error(LocalizableMessage.raw("Error decoding response value", new Object[0]), e);
                }
            }
            for (Control control : result.getControls()) {
                newResult.addControl(control);
            }
            return newResult;
        }
    }

    private static final class RequestDecoder
    implements ExtendedRequestDecoder<GetConnectionIdExtendedRequest, GetConnectionIdExtendedResult> {
        private RequestDecoder() {
        }

        @Override
        public GetConnectionIdExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            GetConnectionIdExtendedRequest newRequest = new GetConnectionIdExtendedRequest();
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

