/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ArgumentException;
import com.forgerock.opendj.cli.CliMessages;
import java.util.List;

public final class TrailingArgumentsConstraints {
    final boolean allowsTrailingArguments;
    final int minTrailingArguments;
    final int maxTrailingArguments;
    final String trailingArgsDisplayName;

    public TrailingArgumentsConstraints() {
        this(false, 0, 0, null);
    }

    public TrailingArgumentsConstraints(boolean allowsTrailingArguments, int minTrailingArguments, int maxTrailingArguments, String trailingArgsDisplayName) {
        this.allowsTrailingArguments = allowsTrailingArguments;
        this.minTrailingArguments = minTrailingArguments;
        this.maxTrailingArguments = maxTrailingArguments;
        this.trailingArgsDisplayName = trailingArgsDisplayName;
    }

    void checkAdditionalTrailingArgsAllowed(List<String> trailingArguments) throws ArgumentException {
        if (!this.allowsTrailingArguments && trailingArguments.size() > 0) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_DISALLOWED_TRAILING_ARGUMENT.get(trailingArguments.get(0)));
        }
        if (0 < this.maxTrailingArguments && this.maxTrailingArguments < trailingArguments.size()) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_TOO_MANY_TRAILING_ARGS.get(this.maxTrailingArguments));
        }
    }

    void checkMinTailingArgsProvided(List<String> trailingArguments) throws ArgumentException {
        if (this.allowsTrailingArguments && this.minTrailingArguments > 0 && trailingArguments.size() < this.minTrailingArguments) {
            throw new ArgumentException(CliMessages.ERR_ARGPARSER_TOO_FEW_TRAILING_ARGUMENTS.get(this.minTrailingArguments));
        }
    }

    void append(StringBuilder buffer) {
        if (this.allowsTrailingArguments) {
            buffer.append(' ');
            if (this.trailingArgsDisplayName != null) {
                buffer.append(this.trailingArgsDisplayName);
            } else {
                buffer.append(CliMessages.INFO_ARGPARSER_USAGE_TRAILINGARGS.get());
            }
        }
    }

    String getSynopsisArgs() {
        if (this.allowsTrailingArguments) {
            if (this.trailingArgsDisplayName != null) {
                return this.trailingArgsDisplayName;
            }
            return CliMessages.INFO_ARGPARSER_USAGE_TRAILINGARGS.get().toString();
        }
        return null;
    }
}

