/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import java.util.HashMap;
import java.util.Map;

public enum ReturnCode {
    SUCCESS(0),
    ERROR_UNEXPECTED(1),
    ERROR_USER_DATA(2),
    PROTOCOL_ERROR(2),
    ERROR_SERVER_ALREADY_INSTALLED(3),
    ERROR_INITIALIZING_SERVER(4),
    ERROR_PASSWORD_LIMIT(5),
    ERROR_USER_CANCELLED(6),
    ERROR_LICENSE_NOT_ACCEPTED(7),
    AUTH_METHOD_NOT_SUPPORTED(7),
    JAVA_VERSION_INCOMPATIBLE(8),
    APPLICATION_ERROR(10),
    SASL_BIND_IN_PROGRESS(14),
    CONFLICTING_ARGS(18),
    CONSTRAINT_VIOLATION(19),
    NO_SUCH_OBJECT(32),
    INVALID_CREDENTIALS(49),
    INSUFFICIENT_ACCESS_RIGHTS(50),
    ENTRY_ALREADY_EXISTS(68),
    OTHER(80),
    CLIENT_SIDE_SERVER_DOWN(81),
    CLIENT_SIDE_LOCAL_ERROR(82),
    CLIENT_SIDE_ENCODING_ERROR(83),
    CLIENT_SIDE_DECODING_ERROR(84),
    CLIENT_SIDE_AUTH_UNKNOWN(86),
    CLIENT_SIDE_PARAM_ERROR(89),
    CLIENT_SIDE_CONNECT_ERROR(91);

    private int returnCode;
    private static final Map<Integer, String> RETURNCODE;

    private ReturnCode(int returnCode) {
        this.returnCode = returnCode;
    }

    public int get() {
        return this.returnCode;
    }

    public static String get(int code) {
        return RETURNCODE.get(code);
    }

    static {
        RETURNCODE = new HashMap<Integer, String>();
        for (ReturnCode rc : ReturnCode.values()) {
            RETURNCODE.put(rc.get(), rc.name());
        }
    }
}

