/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.io.IOException;
import java.nio.channels.AsynchronousSocketChannel;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jdk.management.resource.ResourceId;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;

public class FutureWrapper<T>
implements Future<T> {
    private final Future<T> future;
    private final ResourceId id;
    private final ResourceRequest ra;
    private final long approved;
    private Object clientChannel;
    private boolean isInvoked = false;

    public FutureWrapper(Future<T> future, ResourceId resourceId, ResourceRequest resourceRequest, long l) {
        this.future = future;
        this.id = resourceId;
        this.ra = resourceRequest;
        this.approved = l;
    }

    public FutureWrapper(Future<T> future) {
        this(future, null, null, 0L);
    }

    public FutureWrapper(Future<T> future, Object object) {
        this(future, null, null, 0L);
        this.clientChannel = object;
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.future.cancel(bl);
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        T t = this.future.get();
        this.processResult(t);
        return t;
    }

    @Override
    public T get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        T t = this.future.get(l, timeUnit);
        this.processResult(t);
        return t;
    }

    private synchronized void processResult(T t) {
        if (this.isInvoked) {
            return;
        }
        this.isInvoked = true;
        if (t instanceof Number) {
            int n = ((Number)t).intValue();
            if (n == -1) {
                this.ra.request(-this.approved, this.id);
            } else {
                this.ra.request(-(this.approved - (long)n), this.id);
            }
        } else if (t instanceof AsynchronousSocketChannel || this.clientChannel != null) {
            AsynchronousSocketChannel asynchronousSocketChannel = (AsynchronousSocketChannel)t;
            asynchronousSocketChannel = t != null ? (AsynchronousSocketChannel)t : (AsynchronousSocketChannel)this.clientChannel;
            ResourceIdImpl resourceIdImpl = null;
            try {
                resourceIdImpl = ResourceIdImpl.of(asynchronousSocketChannel.getLocalAddress());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ResourceRequest resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(asynchronousSocketChannel);
            long l = 0L;
            ResourceRequestDeniedException resourceRequestDeniedException = null;
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    resourceRequestDeniedException = new ResourceRequestDeniedException("Resource limited: too many open server socket channels");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException2) {
                resourceRequestDeniedException = resourceRequestDeniedException2;
            }
            if (resourceRequestDeniedException == null) {
                resourceRequest.request(-(l - 1L), resourceIdImpl);
            } else {
                resourceRequest.request(-l, resourceIdImpl);
                try {
                    asynchronousSocketChannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

